package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * 3.5客户端库存信息
 */
@ApiModel(description = "3.5客户端库存信息")

@JsonInclude(NON_NULL)
public class ThreePointFiveClientInvoiceStockInfo implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("miUserId")
  private String miUserId = null;

  @JsonProperty("taxNo")
  private String taxNo = null;

  @JsonProperty("taxDeviceMachineNo")
  private String taxDeviceMachineNo = null;

  @JsonProperty("invoiceType")
  private String invoiceType = null;

  @JsonProperty("invoiceStockNum")
  private Long invoiceStockNum = null;

  @JsonProperty("invoiceStockDate")
  private String invoiceStockDate = null;

  @JsonIgnore
  public ThreePointFiveClientInvoiceStockInfo miUserId(String miUserId) {
    this.miUserId = miUserId;
    return this;
  }

   /**
   * Mi账号
   * @return miUserId
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "Mi账号")
  public String getMiUserId() {
    return miUserId;
  }

  public void setMiUserId(String miUserId) {
    this.miUserId = miUserId;
  }

  @JsonIgnore
  public ThreePointFiveClientInvoiceStockInfo taxNo(String taxNo) {
    this.taxNo = taxNo;
    return this;
  }

   /**
   * 公司税号
   * @return taxNo
  **/


  @ApiModelProperty(value = "公司税号")
  public String getTaxNo() {
    return taxNo;
  }

  public void setTaxNo(String taxNo) {
    this.taxNo = taxNo;
  }

  @JsonIgnore
  public ThreePointFiveClientInvoiceStockInfo taxDeviceMachineNo(String taxDeviceMachineNo) {
    this.taxDeviceMachineNo = taxDeviceMachineNo;
    return this;
  }

   /**
   * 开票机号
   * @return taxDeviceMachineNo
  **/


  @ApiModelProperty(value = "开票机号")
  public String getTaxDeviceMachineNo() {
    return taxDeviceMachineNo;
  }

  public void setTaxDeviceMachineNo(String taxDeviceMachineNo) {
    this.taxDeviceMachineNo = taxDeviceMachineNo;
  }

  @JsonIgnore
  public ThreePointFiveClientInvoiceStockInfo invoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

   /**
   * 发票类型
   * @return invoiceType
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "发票类型")
  public String getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
  }

  @JsonIgnore
  public ThreePointFiveClientInvoiceStockInfo invoiceStockNum(Long invoiceStockNum) {
    this.invoiceStockNum = invoiceStockNum;
    return this;
  }

   /**
   * 剩余发票
   * @return invoiceStockNum
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "剩余发票")
  public Long getInvoiceStockNum() {
    return invoiceStockNum;
  }

  public void setInvoiceStockNum(Long invoiceStockNum) {
    this.invoiceStockNum = invoiceStockNum;
  }

  @JsonIgnore
  public ThreePointFiveClientInvoiceStockInfo invoiceStockDate(String invoiceStockDate) {
    this.invoiceStockDate = invoiceStockDate;
    return this;
  }

   /**
   * 库存数据更新时间 格式：yyyyMMddHHmmss
   * @return invoiceStockDate
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "库存数据更新时间 格式：yyyyMMddHHmmss")
  public String getInvoiceStockDate() {
    return invoiceStockDate;
  }

  public void setInvoiceStockDate(String invoiceStockDate) {
    this.invoiceStockDate = invoiceStockDate;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ThreePointFiveClientInvoiceStockInfo threePointFiveClientInvoiceStockInfo = (ThreePointFiveClientInvoiceStockInfo) o;
    return Objects.equals(this.miUserId, threePointFiveClientInvoiceStockInfo.miUserId) &&
        Objects.equals(this.taxNo, threePointFiveClientInvoiceStockInfo.taxNo) &&
        Objects.equals(this.taxDeviceMachineNo, threePointFiveClientInvoiceStockInfo.taxDeviceMachineNo) &&
        Objects.equals(this.invoiceType, threePointFiveClientInvoiceStockInfo.invoiceType) &&
        Objects.equals(this.invoiceStockNum, threePointFiveClientInvoiceStockInfo.invoiceStockNum) &&
        Objects.equals(this.invoiceStockDate, threePointFiveClientInvoiceStockInfo.invoiceStockDate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(miUserId, taxNo, taxDeviceMachineNo, invoiceType, invoiceStockNum, invoiceStockDate);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ThreePointFiveClientInvoiceStockInfo {\n");
    
    sb.append("    miUserId: ").append(toIndentedString(miUserId)).append("\n");
    sb.append("    taxNo: ").append(toIndentedString(taxNo)).append("\n");
    sb.append("    taxDeviceMachineNo: ").append(toIndentedString(taxDeviceMachineNo)).append("\n");
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("    invoiceStockNum: ").append(toIndentedString(invoiceStockNum)).append("\n");
    sb.append("    invoiceStockDate: ").append(toIndentedString(invoiceStockDate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
