package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.LicenseInfo;
import com.xforceplus.micro.tax.device.contract.model.OperateInfo;
import com.xforceplus.micro.tax.device.contract.model.RequestHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * UpdateDeviceStatusRequest
 */

@JsonInclude(NON_NULL)
public class UpdateDeviceStatusRequest implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("head")
  private RequestHead head = null;

  @JsonProperty("deviceId")
  private List<Long> deviceId = new ArrayList<>();

  @JsonProperty("deviceUns")
  private List<String> deviceUns = new ArrayList<>();

  @JsonProperty("fromSystem")
  private String fromSystem = null;

  @JsonProperty("remark")
  private String remark = null;

  @JsonProperty("operateInfo")
  private OperateInfo operateInfo = null;

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("licenseInfo")
  private LicenseInfo licenseInfo = null;

  @JsonIgnore
  public UpdateDeviceStatusRequest head(RequestHead head) {
    this.head = head;
    return this;
  }

   /**
   * 标准请求头信息
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "标准请求头信息")
  public RequestHead getHead() {
    return head;
  }

  public void setHead(RequestHead head) {
    this.head = head;
  }

  @JsonIgnore
  public UpdateDeviceStatusRequest deviceId(List<Long> deviceId) {
    this.deviceId = deviceId;
    return this;
  }

  public UpdateDeviceStatusRequest addDeviceIdItem(Long deviceIdItem) {
    this.deviceId.add(deviceIdItem);
    return this;
  }

   /**
   * 设备id（已废弃，用deviceUns代替）
   * @return deviceId
  **/


  @ApiModelProperty(value = "设备id（已废弃，用deviceUns代替）")
  public List<Long> getDeviceId() {
    return deviceId;
  }

  public void setDeviceId(List<Long> deviceId) {
    this.deviceId = deviceId;
  }

  @JsonIgnore
  public UpdateDeviceStatusRequest deviceUns(List<String> deviceUns) {
    this.deviceUns = deviceUns;
    return this;
  }

  public UpdateDeviceStatusRequest addDeviceUnsItem(String deviceUnsItem) {
    this.deviceUns.add(deviceUnsItem);
    return this;
  }

   /**
   * 设备唯一码
   * @return deviceUns
  **/


  @ApiModelProperty(value = "设备唯一码")
  public List<String> getDeviceUns() {
    return deviceUns;
  }

  public void setDeviceUns(List<String> deviceUns) {
    this.deviceUns = deviceUns;
  }

  @JsonIgnore
  public UpdateDeviceStatusRequest fromSystem(String fromSystem) {
    this.fromSystem = fromSystem;
    return this;
  }

   /**
   * 来源系统
   * @return fromSystem
  **/


  @ApiModelProperty(value = "来源系统")
  public String getFromSystem() {
    return fromSystem;
  }

  public void setFromSystem(String fromSystem) {
    this.fromSystem = fromSystem;
  }

  @JsonIgnore
  public UpdateDeviceStatusRequest remark(String remark) {
    this.remark = remark;
    return this;
  }

   /**
   * 备注
   * @return remark
  **/


  @ApiModelProperty(value = "备注")
  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  @JsonIgnore
  public UpdateDeviceStatusRequest operateInfo(OperateInfo operateInfo) {
    this.operateInfo = operateInfo;
    return this;
  }

   /**
   * 操作信息
   * @return operateInfo
  **/

  @Valid

  @ApiModelProperty(value = "操作信息")
  public OperateInfo getOperateInfo() {
    return operateInfo;
  }

  public void setOperateInfo(OperateInfo operateInfo) {
    this.operateInfo = operateInfo;
  }

  @JsonIgnore
  public UpdateDeviceStatusRequest status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 设备状态（0：待审核 1:审核通过 2：审核失败 11：启用 12：未启用 21：关闭 22：删除）（传入审核通过状态时，系统会将状态自动变更为未启用状态）
   * @return status
  **/


  @ApiModelProperty(value = "设备状态（0：待审核 1:审核通过 2：审核失败 11：启用 12：未启用 21：关闭 22：删除）（传入审核通过状态时，系统会将状态自动变更为未启用状态）")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @JsonIgnore
  public UpdateDeviceStatusRequest licenseInfo(LicenseInfo licenseInfo) {
    this.licenseInfo = licenseInfo;
    return this;
  }

   /**
   * 授权文件信息
   * @return licenseInfo
  **/

  @Valid

  @ApiModelProperty(value = "授权文件信息")
  public LicenseInfo getLicenseInfo() {
    return licenseInfo;
  }

  public void setLicenseInfo(LicenseInfo licenseInfo) {
    this.licenseInfo = licenseInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpdateDeviceStatusRequest updateDeviceStatusRequest = (UpdateDeviceStatusRequest) o;
    return Objects.equals(this.head, updateDeviceStatusRequest.head) &&
        Objects.equals(this.deviceId, updateDeviceStatusRequest.deviceId) &&
        Objects.equals(this.deviceUns, updateDeviceStatusRequest.deviceUns) &&
        Objects.equals(this.fromSystem, updateDeviceStatusRequest.fromSystem) &&
        Objects.equals(this.remark, updateDeviceStatusRequest.remark) &&
        Objects.equals(this.operateInfo, updateDeviceStatusRequest.operateInfo) &&
        Objects.equals(this.status, updateDeviceStatusRequest.status) &&
        Objects.equals(this.licenseInfo, updateDeviceStatusRequest.licenseInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, deviceId, deviceUns, fromSystem, remark, operateInfo, status, licenseInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpdateDeviceStatusRequest {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    deviceId: ").append(toIndentedString(deviceId)).append("\n");
    sb.append("    deviceUns: ").append(toIndentedString(deviceUns)).append("\n");
    sb.append("    fromSystem: ").append(toIndentedString(fromSystem)).append("\n");
    sb.append("    remark: ").append(toIndentedString(remark)).append("\n");
    sb.append("    operateInfo: ").append(toIndentedString(operateInfo)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    licenseInfo: ").append(toIndentedString(licenseInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
