package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.CompanyInfo;
import com.xforceplus.micro.tax.device.contract.model.OperateInfo;
import com.xforceplus.micro.tax.device.contract.model.OriginAccountTerminalInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * 终端信息
 */
@ApiModel(description = "终端信息")

@JsonInclude(NON_NULL)
public class UpdateTerminalInfo implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("terminalUn")
  private String terminalUn = null;

  @JsonProperty("deviceId")
  private Long deviceId = null;

  @JsonProperty("deviceUn")
  private String deviceUn = null;

  @JsonProperty("operateInfo")
  private OperateInfo operateInfo = null;

  @JsonProperty("companyInfo")
  private CompanyInfo companyInfo = null;

  @JsonProperty("terminalNo")
  private String terminalNo = null;

  @JsonProperty("terminalName")
  private String terminalName = null;

  @JsonProperty("terminalType")
  private Integer terminalType = null;

  @JsonProperty("terminalTypeMode")
  private Integer terminalTypeMode = 0;

  @JsonProperty("invoiceType")
  private List<String> invoiceType = new ArrayList<>();

  @JsonProperty("supportService")
  private List<String> supportService = new ArrayList<>();

  @JsonProperty("paddingLeft")
  private Integer paddingLeft = null;

  @JsonProperty("paddingTop")
  private Integer paddingTop = null;

  @JsonProperty("printInvoiceTerminalId")
  private Long printInvoiceTerminalId = null;

  @JsonProperty("printSaleListTerminalId")
  private Long printSaleListTerminalId = null;

  @JsonProperty("uKeySupportFlag")
  private Integer uKeySupportFlag = null;

  @JsonProperty("customExtra")
  private String customExtra = null;

  @JsonProperty("email")
  private String email = null;

  @JsonProperty("phone")
  private String phone = null;

  @JsonProperty("fromSystem")
  private String fromSystem = null;

  @JsonProperty("originAccountInfo")
  private OriginAccountTerminalInfo originAccountInfo = null;

  @JsonIgnore
  public UpdateTerminalInfo id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 终端id（已废弃，用terminalUn代替）
   * @return id
  **/


  @ApiModelProperty(value = "终端id（已废弃，用terminalUn代替）")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public UpdateTerminalInfo terminalUn(String terminalUn) {
    this.terminalUn = terminalUn;
    return this;
  }

   /**
   * 终端唯一码
   * @return terminalUn
  **/


  @ApiModelProperty(value = "终端唯一码")
  public String getTerminalUn() {
    return terminalUn;
  }

  public void setTerminalUn(String terminalUn) {
    this.terminalUn = terminalUn;
  }

  @JsonIgnore
  public UpdateTerminalInfo deviceId(Long deviceId) {
    this.deviceId = deviceId;
    return this;
  }

   /**
   * 设备id，服务器终端时传入（已废弃，用deviceUn代替）
   * @return deviceId
  **/


  @ApiModelProperty(value = "设备id，服务器终端时传入（已废弃，用deviceUn代替）")
  public Long getDeviceId() {
    return deviceId;
  }

  public void setDeviceId(Long deviceId) {
    this.deviceId = deviceId;
  }

  @JsonIgnore
  public UpdateTerminalInfo deviceUn(String deviceUn) {
    this.deviceUn = deviceUn;
    return this;
  }

   /**
   * 设备唯一码，服务器终端时传入
   * @return deviceUn
  **/


  @ApiModelProperty(value = "设备唯一码，服务器终端时传入")
  public String getDeviceUn() {
    return deviceUn;
  }

  public void setDeviceUn(String deviceUn) {
    this.deviceUn = deviceUn;
  }

  @JsonIgnore
  public UpdateTerminalInfo operateInfo(OperateInfo operateInfo) {
    this.operateInfo = operateInfo;
    return this;
  }

   /**
   * 操作信息
   * @return operateInfo
  **/

  @Valid

  @ApiModelProperty(value = "操作信息")
  public OperateInfo getOperateInfo() {
    return operateInfo;
  }

  public void setOperateInfo(OperateInfo operateInfo) {
    this.operateInfo = operateInfo;
  }

  @JsonIgnore
  public UpdateTerminalInfo companyInfo(CompanyInfo companyInfo) {
    this.companyInfo = companyInfo;
    return this;
  }

   /**
   * 公司信息
   * @return companyInfo
  **/

  @Valid

  @ApiModelProperty(value = "公司信息")
  public CompanyInfo getCompanyInfo() {
    return companyInfo;
  }

  public void setCompanyInfo(CompanyInfo companyInfo) {
    this.companyInfo = companyInfo;
  }

  @JsonIgnore
  public UpdateTerminalInfo terminalNo(String terminalNo) {
    this.terminalNo = terminalNo;
    return this;
  }

   /**
   * 终端编号
   * @return terminalNo
  **/


  @ApiModelProperty(value = "终端编号")
  public String getTerminalNo() {
    return terminalNo;
  }

  public void setTerminalNo(String terminalNo) {
    this.terminalNo = terminalNo;
  }

  @JsonIgnore
  public UpdateTerminalInfo terminalName(String terminalName) {
    this.terminalName = terminalName;
    return this;
  }

   /**
   * 终端名称
   * @return terminalName
  **/


  @ApiModelProperty(value = "终端名称")
  public String getTerminalName() {
    return terminalName;
  }

  public void setTerminalName(String terminalName) {
    this.terminalName = terminalName;
  }

  @JsonIgnore
  public UpdateTerminalInfo terminalType(Integer terminalType) {
    this.terminalType = terminalType;
    return this;
  }

   /**
   * 终端类型 1：单盘 2：服务器  3:底账服务器  4:区块链终端 5:VUKey终端
   * @return terminalType
  **/


  @ApiModelProperty(value = "终端类型 1：单盘 2：服务器  3:底账服务器  4:区块链终端 5:VUKey终端")
  public Integer getTerminalType() {
    return terminalType;
  }

  public void setTerminalType(Integer terminalType) {
    this.terminalType = terminalType;
  }

  @JsonIgnore
  public UpdateTerminalInfo terminalTypeMode(Integer terminalTypeMode) {
    this.terminalTypeMode = terminalTypeMode;
    return this;
  }

   /**
   * 终端类型模式，终端类型为1时，0：表示发票助手（默认） 1：表示百望云
   * @return terminalTypeMode
  **/


  @ApiModelProperty(value = "终端类型模式，终端类型为1时，0：表示发票助手（默认） 1：表示百望云")
  public Integer getTerminalTypeMode() {
    return terminalTypeMode;
  }

  public void setTerminalTypeMode(Integer terminalTypeMode) {
    this.terminalTypeMode = terminalTypeMode;
  }

  @JsonIgnore
  public UpdateTerminalInfo invoiceType(List<String> invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

  public UpdateTerminalInfo addInvoiceTypeItem(String invoiceTypeItem) {
    this.invoiceType.add(invoiceTypeItem);
    return this;
  }

   /**
   * 发票类型（s:增值税专票，c:增值税普票，ce:电子发票，ju:增值税卷票，v:机动车发票，vs:二手机动车发票）
   * @return invoiceType
  **/


  @ApiModelProperty(value = "发票类型（s:增值税专票，c:增值税普票，ce:电子发票，ju:增值税卷票，v:机动车发票，vs:二手机动车发票）")
  public List<String> getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(List<String> invoiceType) {
    this.invoiceType = invoiceType;
  }

  @JsonIgnore
  public UpdateTerminalInfo supportService(List<String> supportService) {
    this.supportService = supportService;
    return this;
  }

  public UpdateTerminalInfo addSupportServiceItem(String supportServiceItem) {
    this.supportService.add(supportServiceItem);
    return this;
  }

   /**
   * 支持的服务（print:打印 make:开票,originAccount:底账）
   * @return supportService
  **/


  @ApiModelProperty(value = "支持的服务（print:打印 make:开票,originAccount:底账）")
  public List<String> getSupportService() {
    return supportService;
  }

  public void setSupportService(List<String> supportService) {
    this.supportService = supportService;
  }

  @JsonIgnore
  public UpdateTerminalInfo paddingLeft(Integer paddingLeft) {
    this.paddingLeft = paddingLeft;
    return this;
  }

   /**
   * 左边距
   * @return paddingLeft
  **/


  @ApiModelProperty(value = "左边距")
  public Integer getPaddingLeft() {
    return paddingLeft;
  }

  public void setPaddingLeft(Integer paddingLeft) {
    this.paddingLeft = paddingLeft;
  }

  @JsonIgnore
  public UpdateTerminalInfo paddingTop(Integer paddingTop) {
    this.paddingTop = paddingTop;
    return this;
  }

   /**
   * 上边距
   * @return paddingTop
  **/


  @ApiModelProperty(value = "上边距")
  public Integer getPaddingTop() {
    return paddingTop;
  }

  public void setPaddingTop(Integer paddingTop) {
    this.paddingTop = paddingTop;
  }

  @JsonIgnore
  public UpdateTerminalInfo printInvoiceTerminalId(Long printInvoiceTerminalId) {
    this.printInvoiceTerminalId = printInvoiceTerminalId;
    return this;
  }

   /**
   * 打印发票终端id
   * @return printInvoiceTerminalId
  **/


  @ApiModelProperty(value = "打印发票终端id")
  public Long getPrintInvoiceTerminalId() {
    return printInvoiceTerminalId;
  }

  public void setPrintInvoiceTerminalId(Long printInvoiceTerminalId) {
    this.printInvoiceTerminalId = printInvoiceTerminalId;
  }

  @JsonIgnore
  public UpdateTerminalInfo printSaleListTerminalId(Long printSaleListTerminalId) {
    this.printSaleListTerminalId = printSaleListTerminalId;
    return this;
  }

   /**
   * 打印销货清单终端id
   * @return printSaleListTerminalId
  **/


  @ApiModelProperty(value = "打印销货清单终端id")
  public Long getPrintSaleListTerminalId() {
    return printSaleListTerminalId;
  }

  public void setPrintSaleListTerminalId(Long printSaleListTerminalId) {
    this.printSaleListTerminalId = printSaleListTerminalId;
  }

  @JsonIgnore
  public UpdateTerminalInfo uKeySupportFlag(Integer uKeySupportFlag) {
    this.uKeySupportFlag = uKeySupportFlag;
    return this;
  }

   /**
   * ukey支持标志，0-不支持 1-支持
   * @return uKeySupportFlag
  **/


  @ApiModelProperty(value = "ukey支持标志，0-不支持 1-支持")
  public Integer getUKeySupportFlag() {
    return uKeySupportFlag;
  }

  public void setUKeySupportFlag(Integer uKeySupportFlag) {
    this.uKeySupportFlag = uKeySupportFlag;
  }

  @JsonIgnore
  public UpdateTerminalInfo customExtra(String customExtra) {
    this.customExtra = customExtra;
    return this;
  }

   /**
   * 自定义额外参数
   * @return customExtra
  **/


  @ApiModelProperty(value = "自定义额外参数")
  public String getCustomExtra() {
    return customExtra;
  }

  public void setCustomExtra(String customExtra) {
    this.customExtra = customExtra;
  }

  @JsonIgnore
  public UpdateTerminalInfo email(String email) {
    this.email = email;
    return this;
  }

   /**
   * 邮箱，用于接收终端激活码
   * @return email
  **/


  @ApiModelProperty(value = "邮箱，用于接收终端激活码")
  public String getEmail() {
    return email;
  }

  public void setEmail(String email) {
    this.email = email;
  }

  @JsonIgnore
  public UpdateTerminalInfo phone(String phone) {
    this.phone = phone;
    return this;
  }

   /**
   * 手机，用于接收终端激活码
   * @return phone
  **/


  @ApiModelProperty(value = "手机，用于接收终端激活码")
  public String getPhone() {
    return phone;
  }

  public void setPhone(String phone) {
    this.phone = phone;
  }

  @JsonIgnore
  public UpdateTerminalInfo fromSystem(String fromSystem) {
    this.fromSystem = fromSystem;
    return this;
  }

   /**
   * 来源系统
   * @return fromSystem
  **/


  @ApiModelProperty(value = "来源系统")
  public String getFromSystem() {
    return fromSystem;
  }

  public void setFromSystem(String fromSystem) {
    this.fromSystem = fromSystem;
  }

  @JsonIgnore
  public UpdateTerminalInfo originAccountInfo(OriginAccountTerminalInfo originAccountInfo) {
    this.originAccountInfo = originAccountInfo;
    return this;
  }

   /**
   * 底账服务器终端信息
   * @return originAccountInfo
  **/

  @Valid

  @ApiModelProperty(value = "底账服务器终端信息")
  public OriginAccountTerminalInfo getOriginAccountInfo() {
    return originAccountInfo;
  }

  public void setOriginAccountInfo(OriginAccountTerminalInfo originAccountInfo) {
    this.originAccountInfo = originAccountInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpdateTerminalInfo updateTerminalInfo = (UpdateTerminalInfo) o;
    return Objects.equals(this.id, updateTerminalInfo.id) &&
        Objects.equals(this.terminalUn, updateTerminalInfo.terminalUn) &&
        Objects.equals(this.deviceId, updateTerminalInfo.deviceId) &&
        Objects.equals(this.deviceUn, updateTerminalInfo.deviceUn) &&
        Objects.equals(this.operateInfo, updateTerminalInfo.operateInfo) &&
        Objects.equals(this.companyInfo, updateTerminalInfo.companyInfo) &&
        Objects.equals(this.terminalNo, updateTerminalInfo.terminalNo) &&
        Objects.equals(this.terminalName, updateTerminalInfo.terminalName) &&
        Objects.equals(this.terminalType, updateTerminalInfo.terminalType) &&
        Objects.equals(this.terminalTypeMode, updateTerminalInfo.terminalTypeMode) &&
        Objects.equals(this.invoiceType, updateTerminalInfo.invoiceType) &&
        Objects.equals(this.supportService, updateTerminalInfo.supportService) &&
        Objects.equals(this.paddingLeft, updateTerminalInfo.paddingLeft) &&
        Objects.equals(this.paddingTop, updateTerminalInfo.paddingTop) &&
        Objects.equals(this.printInvoiceTerminalId, updateTerminalInfo.printInvoiceTerminalId) &&
        Objects.equals(this.printSaleListTerminalId, updateTerminalInfo.printSaleListTerminalId) &&
        Objects.equals(this.uKeySupportFlag, updateTerminalInfo.uKeySupportFlag) &&
        Objects.equals(this.customExtra, updateTerminalInfo.customExtra) &&
        Objects.equals(this.email, updateTerminalInfo.email) &&
        Objects.equals(this.phone, updateTerminalInfo.phone) &&
        Objects.equals(this.fromSystem, updateTerminalInfo.fromSystem) &&
        Objects.equals(this.originAccountInfo, updateTerminalInfo.originAccountInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, terminalUn, deviceId, deviceUn, operateInfo, companyInfo, terminalNo, terminalName, terminalType, terminalTypeMode, invoiceType, supportService, paddingLeft, paddingTop, printInvoiceTerminalId, printSaleListTerminalId, uKeySupportFlag, customExtra, email, phone, fromSystem, originAccountInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpdateTerminalInfo {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    terminalUn: ").append(toIndentedString(terminalUn)).append("\n");
    sb.append("    deviceId: ").append(toIndentedString(deviceId)).append("\n");
    sb.append("    deviceUn: ").append(toIndentedString(deviceUn)).append("\n");
    sb.append("    operateInfo: ").append(toIndentedString(operateInfo)).append("\n");
    sb.append("    companyInfo: ").append(toIndentedString(companyInfo)).append("\n");
    sb.append("    terminalNo: ").append(toIndentedString(terminalNo)).append("\n");
    sb.append("    terminalName: ").append(toIndentedString(terminalName)).append("\n");
    sb.append("    terminalType: ").append(toIndentedString(terminalType)).append("\n");
    sb.append("    terminalTypeMode: ").append(toIndentedString(terminalTypeMode)).append("\n");
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("    supportService: ").append(toIndentedString(supportService)).append("\n");
    sb.append("    paddingLeft: ").append(toIndentedString(paddingLeft)).append("\n");
    sb.append("    paddingTop: ").append(toIndentedString(paddingTop)).append("\n");
    sb.append("    printInvoiceTerminalId: ").append(toIndentedString(printInvoiceTerminalId)).append("\n");
    sb.append("    printSaleListTerminalId: ").append(toIndentedString(printSaleListTerminalId)).append("\n");
    sb.append("    uKeySupportFlag: ").append(toIndentedString(uKeySupportFlag)).append("\n");
    sb.append("    customExtra: ").append(toIndentedString(customExtra)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    phone: ").append(toIndentedString(phone)).append("\n");
    sb.append("    fromSystem: ").append(toIndentedString(fromSystem)).append("\n");
    sb.append("    originAccountInfo: ").append(toIndentedString(originAccountInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
