package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.RequestHead;
import com.xforceplus.micro.tax.device.contract.model.UpdateTerminalInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * UpdateTerminalRequest
 */

@JsonInclude(NON_NULL)
public class UpdateTerminalRequest implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("head")
  private RequestHead head = null;

  @JsonProperty("terminalInfo")
  private UpdateTerminalInfo terminalInfo = null;

  @JsonIgnore
  public UpdateTerminalRequest head(RequestHead head) {
    this.head = head;
    return this;
  }

   /**
   * 标准请求头信息
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "标准请求头信息")
  public RequestHead getHead() {
    return head;
  }

  public void setHead(RequestHead head) {
    this.head = head;
  }

  @JsonIgnore
  public UpdateTerminalRequest terminalInfo(UpdateTerminalInfo terminalInfo) {
    this.terminalInfo = terminalInfo;
    return this;
  }

   /**
   * 终端信息
   * @return terminalInfo
  **/

  @Valid

  @ApiModelProperty(value = "终端信息")
  public UpdateTerminalInfo getTerminalInfo() {
    return terminalInfo;
  }

  public void setTerminalInfo(UpdateTerminalInfo terminalInfo) {
    this.terminalInfo = terminalInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpdateTerminalRequest updateTerminalRequest = (UpdateTerminalRequest) o;
    return Objects.equals(this.head, updateTerminalRequest.head) &&
        Objects.equals(this.terminalInfo, updateTerminalRequest.terminalInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, terminalInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpdateTerminalRequest {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    terminalInfo: ").append(toIndentedString(terminalInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
