package com.xforceplus.micro.tax.device.contract.model.ae;

import com.xforceplus.micro.tax.device.contract.model.client.devops.PageDTO;
import com.xforceplus.micro.tax.device.contract.model.vatv2.model.BaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author Bobo
 * @create 2023/6/21 16:59
 * @since 1.0.0
 */
public class AeClientQueryMessage {

    @EqualsAndHashCode(callSuper = true)
    @Data
    public static class Response extends BaseResponseDto {

        /**
         * 查询数据结果
         */
        private Result result = new AeClientQueryMessage.Response.Result();

        @Data
        public static class Result {
            PageDTO page;
            List<AeClientDTO> aeClientDTOList;
        }
    }

    @Data
    public static class AeClientDTO {
        private Long id;
        private String createdAt;
        private String updatedAt;
        private String tenantNo;
        private String hostname;
        private String clientBaseUrl;
        private Integer maxCpuRate;
        private Integer maxMemoryRate;
        private Integer maxIssuer;
        private int currentIssuerNum;
        private int currentCpuRate;
        private int currentMemoryRate;
        private boolean statusFlag;
        private boolean greyPodFlag;
        private String createdBy;
        private String updatedBy;
    }

}
