package com.xforceplus.micro.tax.device.contract.model.ae;

import com.xforceplus.micro.tax.device.contract.model.vatv2.model.BaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author Bobo
 * @create 2023/1/11 11:43
 * @since 1.0.0
 */
public class AeIssuerDevOpsMessage {

    @Data
    public static class Request {

        private Long id;
        private String taxNo;
        private String issuer;
        private String issueType;
        private String account;
        private String password;
        private boolean mockIssuerFlag;

    }

    @EqualsAndHashCode(callSuper = true)
    @Data
    public static class Response extends BaseResponseDto {

        private Result result = new Result();

        @Data
        public static class Result {
            private Long id;
        }
    }
}
