package com.xforceplus.micro.tax.device.contract.model.ae;

import com.xforceplus.micro.tax.device.contract.model.client.devops.PageDTO;
import com.xforceplus.micro.tax.device.contract.model.vatv2.model.BaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 全电开票人列表查询
 *
 * @author Bobo
 * @create 2023/1/10 13:44
 * @since 1.0.0
 */
public class AeIssuerQueryDevOpsMessage {
    @EqualsAndHashCode(callSuper = true)
    @Data
    public static class Response extends BaseResponseDto {

        /**
         * 查询数据结果
         */
        private Result result = new Result();

        @Data
        public static class Result {
            PageDTO page;
            List<AeIssuerDTO> aeIssuerDTOList;
        }
    }

    @Data
    public static class AeIssuerDTO {
        private Long id;
        private String createdAt;
        private String updatedAt;
        private String unionId;
        private String taxNo;
        private String issuer;
        private String issueType;
        private String phone;
        private String queueName;
        private String account;
        private String password;
        private boolean onlineFlag;
        private boolean mockIssuerFlag;
        private String createdBy;
        private String updatedBy;
    }
}
