package com.xforceplus.micro.tax.device.contract.model.ae;

import com.xforceplus.micro.tax.device.contract.model.vatv2.model.BaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author Bobo
 * @create 2022/7/19 14:35
 * @since 1.0.0
 */
public class AllElectricMessage {

    @Data
    public static class Request {

        private Long id;
        private String tenantNo;
        private String taxNo;
        private String companyName;
        private String issueTypeList;
        private String aeLoginType;
        private String userPlatformNo;
        private String taxPayerType;
        private String taxPayerCreditLevel;
        private String capabilityCodeList;
        private String areaCode;
        private boolean mockIssuerFlag;
        private String createdBy;
        private String updatedBy;
    }

    @EqualsAndHashCode(callSuper = true)
    @Data
    public static class Response extends BaseResponseDto {

        /**
         * 查询数据结果
         */
        private Result result = new Response.Result();

        @Data
        public static class Result {
            private Long id;
        }
    }
}
