package com.xforceplus.micro.tax.device.contract.model.ae;

import com.xforceplus.micro.tax.device.contract.model.client.devops.PageDTO;
import com.xforceplus.micro.tax.device.contract.model.vatv2.model.BaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.sql.Timestamp;
import java.util.List;

/**
 * @author Bobo
 * @create 2022/7/19 14:28
 * @since 1.0.0
 */
public class AllElectricQueryMessage {

    @EqualsAndHashCode(callSuper = true)
    @Data
    public static class Response extends BaseResponseDto {

        /**
         * 查询数据结果
         */
        private Result result = new Response.Result();

        @Data
        public static class Result {
            PageDTO page;
            List<AeQualificationDTO> aeQualificationDTOList;
        }
    }

    @Data
    public static class AeQualificationDTO {
        private Long id;
        private Timestamp createdAt;
        private Timestamp updatedAt;
        private String tenantNo;
        private String taxNo;
        private String companyName;
        private List<String> issueTypeList;
        private String aeLoginType;
        private String userPlatformNo;
        private String taxPayerType;
        private String taxPayerCreditLevel;
        private List<String> capabilityCodeList;
        private String areaCode;
        private boolean mockIssuerFlag;
        private String createdBy;
        private String updatedBy;
    }
}
