package com.xforceplus.micro.tax.device.contract.model.ae;

import com.xforceplus.micro.tax.device.contract.model.vatv2.model.BaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * ns 配置列表查询
 *
 * @author Bobo
 * @create 2023/1/10 13:44
 * @since 1.0.0
 */
public class DeviceAeNsConfigQueryOneMessage {
    @EqualsAndHashCode(callSuper = true)
    @Data
    public static class Response extends BaseResponseDto {

        /**
         * 查询数据结果
         */
        private Result result = new Result();

        @Data
        public static class Result {
            DeviceAeNsConfigDto deviceAeNsConfigDto;
        }
    }

    @Data
    public static class DeviceAeNsConfigDto {
        private Long id;

        /**
         * 租户
         */
        private String tenantNo;

        /**
         * 接入方平台编号
         */
        private String platformNo;

        /**
         * 密钥
         */
        private String secretKey;

        /**
         * 基础 url
         */
        private String baseUrl;

        /**
         * 启用状态 11 启用，12 未启用
         */
        private String status;

        private String createdAt;
        private String updatedAt;
        private String createdBy;
        private String updatedBy;
    }
}
