package com.xforceplus.micro.tax.device.contract.model.ae;

import lombok.Data;

/**
 * 乐企服务配置消息
 *
 * @author Bobo
 * @create 2023/2/23 14:01
 * @since 1.0.0
 */
public class DeviceAeNsConfigUpsertMessage {

    @Data
    public static class Response {

        private String code = "1";
        private String message = "成功";
        private String traceId;
        private Result result = new Result();

        @Data
        public static class Result {
            private Long id;
        }
    }

    @Data
    public static class Request {
        private Long id;

        /**
         * 租户ID
         */
        private String tenantNo;

        /**
         * 接入方平台编号
         */
        private String platformNo;

        /**
         * 密钥
         */
        private String secretKey;

        /**
         * 基础 url
         */
        private String baseUrl;

        /**
         * 启用状态 11 启用，12 未启用
         */
        private String status;

        /**
         * 创建人
         */
        private String createdBy;

        /**
         * 修改人
         */
        private String updatedBy;

        private String createdAt;
        private String updatedAt;
    }
}
