package com.xforceplus.micro.tax.device.contract.model.ae;

import com.xforceplus.micro.tax.device.contract.model.client.devops.PageDTO;
import com.xforceplus.micro.tax.device.contract.model.vatv2.model.BaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * ns 配置列表查询
 *
 * @author Bobo
 * @create 2023/1/10 13:44
 * @since 1.0.0
 */
public class DeviceAeNsProxyConfigQueryPageMessage {
    @EqualsAndHashCode(callSuper = true)
    @Data
    public static class Response extends BaseResponseDto {

        /**
         * 查询数据结果
         */
        private Result result = new Result();

        @Data
        public static class Result {
            PageDTO page;
            List<DeviceAeNsProxyConfigDto> deviceAeNsConfigDtoList;
        }
    }

    @Data
    public static class DeviceAeNsProxyConfigDto {
        private Long id;

        /**
         * 租户ID
         */
        private String tenantNo;

        /**
         * 代理名称
         */
        private String proxyName;

        /**
         * 备案 ip
         */
        private String serverIp;

        /**
         * 代理 ip
         */
        private String proxyIp;

        /**
         * 调度地址
         */
        private String dispatchValue;

        /**
         * 属地部署
         */
        private boolean localDeployFlag;

        /**
         * mac地址
         */
        private String macAddress;

        /**
         * CPU序列号（非必须）
         */
        private String cpuSerialNo;

        /**
         * 主板序列号（非必须）
         */
        private String motherboardSerialNo;

        /**
         * 启用状态 11 启用，12 未启用
         */
        private String status;

        private String createdAt;
        private String updatedAt;
        private String createdBy;
        private String updatedBy;
    }
}
