package com.xforceplus.micro.tax.device.contract.model.ae;

import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * 获取任意在线队列
 *
 * @author Bobo
 * @create 2023/7/19 15:00
 * @since 1.0.0
 */
public class GetAnyOnlineQueueMessage {

    @Data
    public static class Response {

        /**
         * 返回码（1为成功 其余为失败）
         */
        private String code = "1";

        /**
         * 返回信息
         */
        private String message = "成功";

        /**
         * 追踪码
         */
        private String traceId;

        /**
         * 结果
         **/
        private Result result = new Result();

        @Data
        public static class Result {

            /**
             * 开票方式列表 ns：乐企 dppt：电票平台（客户端）
             */
            @Deprecated
            private List<String> issueTypeList = new ArrayList<>();

            /**
             * 队列名称
             **/
            @Deprecated
            private String queueName;

            /**
             * 开票人
             **/
            @Deprecated
            private String issuer;

            /**
             * 同步方式
             */
            private List<SyncMethod> syncMethod = new ArrayList<>();

            @Data
            public static class SyncMethod {

                /**
                 * 同步方式 ns：乐企 dppt：电票平台（客户端） input:进项
                 **/
                private String syncType;

                /**
                 * 开票人
                 **/
                private String issuer;

                /**
                 * 调度方式
                 **/
                private String dispatchType;

                /**
                 * 调度目标
                 **/
                private String dispatchValue;

            }

        }
    }
}
