package com.xforceplus.micro.tax.device.contract.model.ae;

import com.xforceplus.micro.tax.device.contract.model.hardware.model.PageDto;
import lombok.Data;

import java.util.List;
import java.util.UUID;

/**
 * 乐企配置消息
 *
 * @author Bobo
 * @create 2023/5/8 18:19
 * @since 1.0.0
 */
public class NsConfigMessage {

    @Data
    public static class Response {

        private String code = "1";
        private String message = "成功";
        private String traceId;

        private Result result = new Result();

        @Data
        public static class Result {
            private PageDto pageDto;
            private List<NsConfigDto> nsConfigDtoList;
        }

        @Data
        public static class NsConfigDto {

            /**
             * 乐企编号
             */
            private String nsCode;

            /**
             * 税号
             */
            private String taxNo;

            /**
             * 公司名称
             */
            private String companyName;

            /**
             * 租户
             */
            private String tenantId;

            /**
             * 租户名称
             */
            private String tenantName;

            /**
             * 密钥
             */
            private String secretKey;

            /**
             * 接入方平台编号
             */
            private String platformNo;

            /**
             * 使用方平台编号
             */
            private String userPlatformNo;

            /**
             * 基础 url
             */
            private String baseUrl;

            /**
             * 区域代码
             */
            private String areaCode;

            /**
             * 能力编码集合
             */
            private List<String> capabilityCodeList;

            /**
             * mock标志
             */
            private boolean mockIssuerFlag;

            /**
             * 随机代理
             */
            private NsProxyConfigDto nsProxyConfigDto;

            /**
             * 业务流水号（“使用单位 id”+“直连单位 id”+“32 位随机生成数” ）
             *
             * @return
             */
            public String getSerialNo() {
                return String.format("%s%s%s", this.userPlatformNo, this.platformNo, UUID.randomUUID().toString().replace("-", ""));
            }
        }

        @Data
        public static class NsProxyConfigDto {

            /**
             * 代理名称
             */
            private String proxyName;

            /**
             * 备案 ip
             */
            private String serverIp;

            /**
             * 代理 ip
             */
            private String proxyIp;

            /**
             * 属地部署
             */
            private boolean localDeployFlag;

            /**
             * mac地址
             */
            private String macAddress;

            /**
             * CPU序列号（非必须）
             */
            private String cpuSerialNo;

            /**
             * 主板序列号（非必须）
             */
            private String motherboardSerialNo;
        }
    }
}
