package com.xforceplus.micro.tax.device.contract.model.billing;

import com.xforceplus.micro.tax.device.contract.model.vatv2.model.BaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 计费服务维护
 *
 * @author Bobo
 * @create 2023/9/4 11:10
 * @since 1.0.0
 */
public class BillingDevOpsMessage {

    @Data
    public static class Request {
        private Long id;
        private String tenantCode;
        private String tenantName;
        private String taxNo;
        private String companyName;
        private String serviceNameList;
        private String createdBy;
        private String updatedBy;
    }

    @EqualsAndHashCode(callSuper = true)
    @Data
    public static class Response extends BaseResponseDto {

        private Result result = new Result();

        @Data
        public static class Result {
            private Long id;
        }
    }
}
