package com.xforceplus.micro.tax.device.contract.model.billing;

import com.xforceplus.micro.tax.device.contract.model.client.devops.PageDTO;
import com.xforceplus.micro.tax.device.contract.model.vatv2.model.BaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.sql.Timestamp;
import java.util.List;

/**
 * 计费服务查询
 *
 * @author Bobo
 * @create 2023/9/4 11:07
 * @since 1.0.0
 */
public class BillingQueryDevOpsMessage {

    @EqualsAndHashCode(callSuper = true)
    @Data
    public static class Response extends BaseResponseDto {

        /**
         * 查询数据结果
         */
        private Result result = new Result();

        @Data
        public static class Result {
            PageDTO page;
            List<BillingDTO> billingDTOList;
        }
    }

    @Data
    public static class BillingDTO {
        private Long id;
        private String createdAt;
        private String updatedAt;
        private String tenantCode;
        private String tenantName;
        private String taxNo;
        private String companyName;
        private List<String> serviceNameList;
        private String createdBy;
        private String updatedBy;
    }
}
