package com.xforceplus.micro.tax.device.contract.model.client;

import com.xforceplus.micro.tax.device.contract.model.vatv2.model.BaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author Bobo
 * @create 2020/11/26 11:23
 * @since 1.0.0
 */
public class ClientUpgradeFilesMessage {

    @Data
    public static class Request {

        /**
         * 更新版本
         */
        private String upgradeVersion;

        /**
         * 更新文件列表
         */
        private String upgradeListedFiles;

    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        private ClientUpgradeFilesMessage.Response.Result result = new ClientUpgradeFilesMessage.Response.Result();

        @Data
        public static class Result {

            /**
             * 更新版本
             */
            private String upgradeVersion;

            /**
             * 更新文件列表
             */
            private String upgradeListedFiles;

        }

    }
}
