package com.xforceplus.micro.tax.device.contract.model.client;

import com.xforceplus.micro.tax.device.contract.model.vatv2.model.BaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author Bobo
 * @create 2020/11/27 11:39
 * @since 1.0.0
 */
public class ClientUpgradePackageMessage {

    @Data
    public static class Request {

        /**
         * 税号
         */
        private String taxCode;

        /**
         * 云环境（ac:阿里云,tc:腾讯云）
         */
        private String cloudEnvironment;

        /**
         * 当前版本
         */
        private String currentVersion;

        /**
         * 更新版本
         */
        private String upgradeVersion;

        /**
         * 更新文件OSS相对路径
         */
        private List<String> paths;

        /**
         * 设备编号（盘号）
         */
        private String deviceNo;

        /**
         * 用户ID
         */
        private String userId;

    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        private ClientUpgradePackageMessage.Response.Result result = new ClientUpgradePackageMessage.Response.Result();

        @Data
        public static class Result {

            /**
             * ZIP包下载链接
             */
            private String downloadUrl;

        }

    }
}
