package com.xforceplus.micro.tax.device.contract.model.client;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author Bobo
 * @create 2020/11/30 17:02
 * @since 1.0.0
 */
@Data
public class TaxDiskLimitInfo {

    @JsonIgnore
    private Long id;

    @JsonIgnore
    private Long openCardId;

    @JsonIgnore
    private String taxCode;

    /**
     * 发票类型(c-纸普 ce-电普 s-专票 se-电专 v-机动车 ju-卷票)
     */
    private String invoiceType;

    /**
     * 离线时限(小时)
     */
    private Integer offLineTimeLimit;

    /**
     * 离线金额(元)
     */
    private BigDecimal offLineAmountLimit;

    /**
     * 单张开票限额(元)
     */
    private BigDecimal singleAmountLimit;

    /**
     * 锁死期(yyyyMMdd)
     */
    private String lockTime;
}
