package com.xforceplus.micro.tax.device.contract.model.client.devops;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.annotation.write.style.ContentRowHeight;
import com.alibaba.excel.annotation.write.style.HeadRowHeight;
import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * @author Thj
 * @createdAt: 2021-04-12 9:42
 * @Description: 统一客户端升级配置 Excel导入模板文件类
 */

@Data
@ContentRowHeight(20)
@HeadRowHeight(20)
public class XClientDevOpsExcelTemplate {

    /**
     * 产品:
     * miniClient:mini客户端
     * XClient:统一客户端
     */
    @NotNull
    @ColumnWidth(16)
    @ExcelProperty(value = "产品", index = 0)
    private String product;

    /**
     * 维度：
     * global:全局
     * taxCode:税号
     * tenant：租户
     * deviceNo:设备编号
     */
    @NotNull
    @ColumnWidth(16)
    @ExcelProperty(value = "配置维度", index = 1)
    private String configType;

    /**
     * 维度对应值
     */
    @ColumnWidth(20)
    @ExcelProperty(value = "维度值", index = 2)
    private String configValue;

    @NotNull
    @ColumnWidth(30)
    @ExcelProperty(value = "升级类型", index = 3)
    private String upgradeType;

    @NotNull
    @ColumnWidth(30)
    @ExcelProperty(value = "升级版本", index = 4)
    private String upgradeVersion;

    @ExcelIgnore
    private String createdBy;

    @ExcelIgnore
    private String updatedBy;

    @ExcelIgnore
    private Integer rowIndex;
}
