package com.xforceplus.micro.tax.device.contract.model.client.devops;

import com.xforceplus.micro.tax.device.contract.model.vatv2.model.BaseResponseDto;
import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * @author Thj
 * @createdAt: 2021-04-12 9:42
 * @Description: 统一客户端升级配置 下载Excel模板标准返回    文件以二进制字节数组存储
 */
public class XClientUpgradeExcelTemPlateMessage {

    @Data
    public static class Request {
        @NotNull
        private String operatedBy;
        @NotNull
        private byte[] byteArrayStr;
    }

    @Data
    public static class Response extends BaseResponseDto {

        /**
         * 二进制字节数组存储文件
         */
        private Result result = new Result();

        @Data
        public static class Result {
            private byte[] data;
        }
    }
}
