package com.xforceplus.micro.tax.device.contract.model.client.devops;

import com.xforceplus.micro.tax.device.contract.model.vatv2.model.BaseResponseDto;
import io.swagger.models.auth.In;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;
import java.sql.Timestamp;
import java.util.List;

public class XClientUpgradeQueryMessage {

    @Data
    public static class Request {

        /**
         * 产品
         * xClient：统一客户端  miniClient：mini客户端  默认：全部
         */
        private String product;

        /**
         * 配置维度
         * (global:全局 tenant:租户 taxCode:税号 deviceNo:设备编号)
         */
        @NotNull
        private String configType;

        /**
         * 维度值（维度为全局时可不填）
         */
        private String configValue;

        /**
         * （normal：正常升级 silent：静默升级）
         */
        private String upgradeType;

        /**
         * 创建人
         */
        private String createdBy;

        /**
         * 更新人
         */
        private String updatedBy;

        /**
         * 当前页码, 默认第一页
         */
        private int currentPage = 1;

        /**
         * 每页条数, 默认大小20条
         */
        private int pageSize = 20;
    }

    @EqualsAndHashCode(callSuper = true)
    @Data
    public static class Response extends BaseResponseDto {

        /**
         * 查询数据结果
         */
        private Result result = new Result();

        @Data
        public static class Result {
            PageDTO page;
            List<UpdateDTO> upgradeList;
        }
    }

    @Data
    public static class UpdateDTO {
        private Long id;
        private String product;
        private String configType;
        private String configValue;
        private String upgradeType;
        private String upgradeVersion;
        private Integer baselineNum;
        private String createdBy;
        private String updatedBy;
        private Timestamp createdAt;
        private Timestamp updatedAt;
    }

}
