package com.xforceplus.micro.tax.device.contract.model.client.devops;

import com.xforceplus.micro.tax.device.contract.model.vatv2.model.BaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author Thj
 * @createdAt: 2021-04-09 11:53
 * @Description:
 */
public class XClientUpgradeUpdateMessage {

    @Data
    public static class Request {

        /**
         * 业务主键
         */
        private Long id;

        /**
         * 产品
         * xClient：统一客户端  miniClient：mini客户端  默认：全部
         */
        private String product;

        /**
         * 配置维度
         * (global:全局 tenant:租户 taxCode:税号 deviceNo:设备编号)
         */
        @NotNull
        private String configType;

        /**
         * 维度值（维度为全局时可不填）
         */
        private String configValue;

        /**
         * （normal：正常升级 silent：静默升级 baseline:基线版本升级）
         */
        private String upgradeType;

        /**
         * 创建人
         */
        private String createdBy;

        /**
         * 更新人
         */
        private String updatedBy;

        /**
         * 升级版本
         */
        private String upgradeVersion;

        /**
         * 基线版本升级数量
         * 升级类型为基线版本升级时不为空
         */
        private String baselineNum;
    }

    @EqualsAndHashCode(callSuper = true)
    @Data
    public static class Response extends BaseResponseDto {

        /**
         * 查询数据结果
         */
        private Result result = new Result();

        @Data
        public static class Result {
            private Long id;
        }
    }
}
