package com.xforceplus.micro.tax.device.contract.model.enumerate;

/**
 * 开票服务器类型枚举
 *
 * @author Bobo
 * @create 2021/10/27 14:27
 * @since 1.0.0
 */
public enum InvoiceServiceTypeEnum {

    /**
     * 单盘
     */
    INVOICE_HELPER("invoice_helper", "单盘"),

    /**
     * 税控服务器
     */
    INVOICE_SERVER("invoice_server", "税控服务器");

    private String code;
    private String name;

    InvoiceServiceTypeEnum(String code, String name) {

        this.code = code;
        this.name = name;
    }

    public static InvoiceServiceTypeEnum fromCode(String code) {

        if (code == null) {
            return null;
        }

        final InvoiceServiceTypeEnum[] values = InvoiceServiceTypeEnum.values();

        for (InvoiceServiceTypeEnum modeEnum : values) {
            if (modeEnum.code.equals(code)) {
                return modeEnum;
            }
        }

        return null;
    }

    public String toCode() {
        return code;
    }

    public String toName() {
        return name;
    }
}
