package com.xforceplus.micro.tax.device.contract.model.hardware;

import lombok.Data;

/**
 * 配置文件修改
 *
 * @author Bobo
 * @create 2021/4/26 14:57
 * @since 1.0.0
 */
public class ConfigUpdateMessage {

    @Data
    public static class Request {

        /**
         * 纳税人识别号
         */
        private String taxCode;

        /**
         * 配置key
         */
        private String configKey;

        /**
         * 配置value
         */
        private String configValue;

    }

    @Data
    public static class RequestV2 {

        /**
         * 配置维度
         * taxCode:税号 deviceUn:设备唯一码
         */
        private String configScope;

        /**
         * 配置维度值
         */
        private String configScopeValue;

        /**
         * 配置key
         */
        private String configKey;

        /**
         * 配置value
         */
        private String configValue;

    }
}
