package com.xforceplus.micro.tax.device.contract.model.hardware;

import com.xforceplus.micro.tax.device.contract.model.vatv2.model.BaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author Bobo
 * @create 2021/3/23 19:43
 * @since 1.0.0
 */
public class DeviceInventoryV2Message {

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        private DeviceInventoryV2Message.Result result = new DeviceInventoryV2Message.Result();
    }

    @Data
    public static class Result {

        private List<DeviceInventoryV2Message.InventoryDto> inventoryList;

    }

    @Data
    public static class InventoryDto {

        /**
         * 税号
         */
        private String taxCode;

        /**
         * 发票类型
         */
        private String invoiceType;

        /**
         * 库存数量
         */
        private Integer quantity;

        /**
         * 开票设备库存信息
         */
        private List<DeviceInventoryDto> deviceInventoryList;

    }

    @Data
    public static class DeviceInventoryDto {

        /**
         * 设备编号
         */
        private String deviceNo;

        /**
         * mi
         */
        private String mi;

        /**
         * 库存数量
         */
        private Integer quantity;

        /**
         * 开票终端库存信息
         */
        private List<TerminalInventoryDto> terminalInventoryList;

    }


    @Data
    public static class TerminalInventoryDto {

        /**
         * 终端编号
         */
        private String terminalNo;

        /**
         * 库存数量
         */
        private Integer quantity;

    }
}
