package com.xforceplus.micro.tax.device.contract.model.hardware;

import com.xforceplus.micro.tax.device.contract.model.client.TaxDiskLimitInfo;
import com.xforceplus.micro.tax.device.contract.model.vatv2.model.BaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 查询设备资质 消息
 *
 * @author Bobo
 * @create 2020/8/21 15:54
 * @since 1.0.0
 */
public class DeviceQualificationsMessage {

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        private DeviceQualificationsMessage.Response.Result result = new DeviceQualificationsMessage.Response.Result();

        @Data
        public static class Result {

            private List<DeviceQualificationsMessage.Response.Qualification> qualificationList;

        }

        @Data
        public static class Qualification {

            /**
             * 税号
             */
            private String taxCode;

            /**
             * 公司名称
             */
            private String companyName;

            /**
             * 设备编号
             */
            private String deviceNo;

            /**
             * mi
             */
            private String mi;

            /**
             * 开票机号
             */
            private Integer taxDeviceMachineNo;

            /**
             * 纳税人性质
             */
            private String natureTaxPayer;

            /**
             * 数据刷新时间 格式：yyyyMMddHHmmss
             */
            private String lastUpdatedAt;

            /**
             * 税盘开票限制信息
             */
            private List<TaxDiskLimitInfo> limitInfoList;

        }

    }
}
