package com.xforceplus.micro.tax.device.contract.model.hardware;

import com.xforceplus.micro.tax.device.contract.model.hardware.model.DeviceStatusDto;
import com.xforceplus.micro.tax.device.contract.model.vatv2.model.BaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 设备状态消息
 *
 * @author Bobo
 * @create 2020/4/21 20:35
 * @since 1.0.0
 */
public class DeviceStatusMessage {

    @Data
    public static class Request {

        /**
         * 账号体系类型（mi：mi账号 un：un账号 el：el账号 el-s：底账服务器 el-x：未知的抵账类型 el-2：2.0底账,deviceUn:4.0体系设备唯一码）
         * 默认:mi
         */
        private String accountType = "mi";

        /**
         * Mi账号
         */
        private List<String> accounts;

    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        private DeviceStatusMessage.Response.Result result = new DeviceStatusMessage.Response.Result();

        @Data
        public class Result {

            /**
             * 设备状态
             */
            private List<DeviceStatusDto> status;

        }

    }
}
