package com.xforceplus.micro.tax.device.contract.model.hardware;

import com.xforceplus.micro.tax.device.contract.model.vatv2.model.BaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 开票规则查询校验规则查询消息
 *
 * @author Bobo
 * @create 2020/4/21 20:30
 * @since 1.0.0
 */
public class MakeInvoiceRuleMessage {

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        private MakeInvoiceRuleMessage.Result result = new MakeInvoiceRuleMessage.Result();

    }

    @Data
    public static class Result {

        /**
         * 单价小数点后的位数（建议）
         */
        private Integer unitPriceScale;

        /**
         * 如果存在多个设备返回，单价小数点后的位数（建议）
         */
        private List<Integer> unitPriceScaleList;
    }
}
