package com.xforceplus.micro.tax.device.contract.model.hardware;

import com.xforceplus.micro.tax.device.contract.model.vatv2.model.BaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author Bobo
 * @create 2021/3/1 16:17
 * @since 1.0.0
 */
public class MakeMonitorMessage {

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        private Result result = new Result();

    }

    @Data
    public static class Result {

        /**
         * 剩余库存份数
         */
        private Integer inventoryNum;

        /**
         * 购票信息描述
         */
        private String buyInvoiceDesc;

        /**
         * 估算开票时长(时间精确到秒)
         */
        private Long estimatedTime;

        /**
         * 开具中的发票数量
         */
        private Integer makingInvoiceCount;

    }
}
