package com.xforceplus.micro.tax.device.contract.model.hardware;

import com.xforceplus.micro.tax.device.contract.model.vatv2.model.OrganizationDto;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 成品油库存上传消息
 *
 * @author Bobo
 * @create 2020/6/22 9:31
 * @since 1.0.0
 */
public class OilInventoryUploadMessage {

    @Data
    public static class Response {

        /**
         * 税号
         */
        private String taxCode;

        /**
         * 平台标识
         */
        private String platformType;

        /**
         * 厂商标识
         */
        private String vendorType;

        /**
         * 设备编号
         */
        private String deviceNo;

        /**
         * 开票机号
         */
        private String invoicingMachineNo;

        /**
         * 设备唯一码
         */
        private String deviceUn;

        /**
         * mi
         */
        private String mi;

        /**
         * 库存时间(yyyy-MM-dd HH:mm:ss.SSS)，内核返回库存数据时间
         */
        private String inventoryTime;

        /**
         * 成品油起始时间(yyyy-MM-dd)
         */
        private String oilStartTime;

        /**
         * 成品油截止时间(yyyy-MM-dd)
         */
        private String oilEndTime;

        /**
         * 组织信息
         */
        private OrganizationDto organization;

        private List<InventoryUploadDetailDto> inventoryList;
    }

    @Data
    public static class InventoryUploadDetailDto {

        /**
         * 税收分类编码
         */
        private String goodsTaxNo;

        /**
         * 数量
         */
        private BigDecimal quantity;

    }
}
