package com.xforceplus.micro.tax.device.contract.model.hardware;

import com.xforceplus.micro.tax.device.contract.model.vatv2.model.BaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

public class QueryPrintTerminalsMessage {
    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        private Result result;

        @Data
        public static class Result {

            /**
             * 终端队列名称（有打印服务时有值）
             */
            private String terminalQueueName;

            /**
             * 终端信息列表
             */
            private List<TerminalDto> terminalList;

        }
    }

    @Data
    public static class TerminalDto {

        /**
         * 税号
         */
        private String taxCode;

        /**
         * 公司名称
         */
        private String companyName;

        /**
         * 终端唯一码
         */
        private String terminalUn;

        /**
         * 终端名称
         */
        private String terminalName;

        /**
         * 状态(enable:启用 disable:未启用)
         */
        private String status;

        /**
         * 终端配置
         */
        private List<ConfigDto> configList;
    }

    @Data
    public static class ConfigDto {
        private String key;
        private String value;
    }
}
