package com.xforceplus.micro.tax.device.contract.model.hardware;

import com.xforceplus.micro.tax.device.contract.model.hardware.model.PageDto;
import com.xforceplus.micro.tax.device.contract.model.vatv2.model.BaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author Bobo
 * @create 2021/3/23 19:43
 * @since 1.0.0
 */
public class RTMartInventoryMessage {

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        private RTMartInventoryMessage.Result result = new RTMartInventoryMessage.Result();
    }

    @Data
    public static class Result {

        private List<RTMartInventoryMessage.InventoryDto> inventoryList;
        private PageDto pageInfo;

    }

    @Data
    public static class InventoryDto {

        /**
         * 税号
         */
        private String taxCode;

        /**
         * 库存数量
         */
        private Integer quantity;

    }
}
