package com.xforceplus.micro.tax.device.contract.model.hardware;

import com.google.common.collect.Lists;
import com.xforceplus.micro.tax.device.contract.model.vatv2.model.BaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 税盘
 *
 * @author zhouwen
 * @date 2021-05-18
 */
public class TaxDiskMessage {

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        private Result result = new Result();

        @Data
        public static class Result {

            private Long tenantId;

            private List<CompanyDto> companyDtoList = Lists.newArrayList();

            @Data
            public static class CompanyDto {

                private String taxNo;

                private List<TaxDiskDto> taxDiskDtoList = Lists.newArrayList();

                @Data
                public static class TaxDiskDto {

                    /**
                     * 设备编号
                     */
                    private String deviceNo;

                    /**
                     * 队列名称
                     */
                    public String queueName;
                }
            }
        }
    }
}
