package com.xforceplus.micro.tax.device.contract.model.hardware;

import com.xforceplus.micro.tax.device.contract.model.vatv2.model.BaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author Bobo
 * @create 2021/2/1 16:20
 * @since 1.0.0
 */
public class TrusteeshipDeviceInventoryMessage {

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        private TrusteeshipDeviceInventoryMessage.Response.Result result = new TrusteeshipDeviceInventoryMessage.Response.Result();

        @Data
        public class Result {

            private Integer pageNo;

            private Integer pageSize;

            private Integer totalCount;

            /**
             * 设备库存
             */
            private List<TrusteeshipDeviceInventoryMessage.DeviceInventoryDto> deviceInventoryList;

        }

    }

    @Data
    public static class DeviceInventoryDto {

        /**
         * 主键
         */
        private Long id;

        /**
         * 租户代码
         */
        private String tenantCode;

        /**
         * MI
         */
        private String miAccount;

        /**
         * 税号
         */
        private String taxCode;

        /**
         * 公司名称
         */
        private String companyName;

        /**
         * 设备编号
         */
        private String deviceNo;

        /**
         * 发票类型
         */
        private String invoiceType;

        /**
         * 剩余库存份数
         */
        private Integer inventoryNum;

        /**
         * 库存获取时间 格式：yyyy-MM-dd HH:mm:ss.SSS
         */
        private String inventoryTime;

    }
}
