package com.xforceplus.micro.tax.device.contract.model.hardware;

import com.xforceplus.micro.tax.device.contract.model.vatv2.model.BaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author Bobo
 * @create 2021/3/9 16:42
 * @since 1.0.0
 */
public class XClientAddHardwareMessage {

    @Data
    public static class Request {

        /**
         * 支持服务
         * print:打印 make:开票,originAccount:底账,assistant：辅助
         */
        private List<String> supportService;

        /**
         * 终端信息
         */
        private TerminalDto terminal;

        /**
         * 终端信息
         */
        private DeviceDto device;

        /**
         *  租户信息
         */
        private List<TenantDto> tenantList;

        /**
         * 公司信息
         */
        private CompanyDto company;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        private XClientAddHardwareMessage.Response.Result result = new XClientAddHardwareMessage.Response.Result();

        @Data
        public class Result {

            /**
             * 终端唯一码
             */
            private String terminalUn;

            /**
             * 设备唯一码
             */
            private String deviceUn;
        }
    }

    @Data
    public static class TerminalDto {

        /**
         * cid
         */
        private String cid;

        /**
         * 终端唯一码
         */
        private String terminalUn;

        /**
         * 终端名称
         */
        private String terminalName;

    }

    @Data
    public static class DeviceDto {

        /**
         * 设备唯一码
         */
        private String deviceUn;

        /**
         * 设备编号
         */
        private String deviceNo;

        /**
         * 设备类型
         * BW,BK,HX,HK,EK
         */
        private String deviceType;

        /**
         * 开票机号
         */
        private Integer taxDeviceMachineNo;

        /**
         * 国税自定义密码
         */
        private String nationalTaxPassword;

        /**
         * 底账确认密码
         */
        private String elConfirmPassword;

        /**
         * 税务数字证书密码
         */
        private String taxDeviceDigitalPassword;

        /**
         * 税控盘密码
         */
        private String taxDevicePassword;

    }

    @Data
    public static class TenantDto {

        /**
         * 租户ID
         */
        private Long tenantId;

        /**
         * 租户名称
         */
        private String tenantName;

    }

    @Data
    public static class CompanyDto {

        /**
         * 公司Id
         */
        private Long companyId;

        /**
         * 公司名称
         */
        private String companyName;

        /**
         * 公司税号
         */
        private String companyTaxCode;

        /**
         * 公司所在省份
         */
        private String province;

        /**
         * 公司所在城市
         */
        private String city;

        /**
         * 企业地址
         */
        private String address;
    }

}
