package com.xforceplus.micro.tax.device.contract.model.hardware;

import com.xforceplus.micro.tax.device.contract.model.vatv2.model.BaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author Bobo
 * @create 2021/3/9 16:42
 * @since 1.0.0
 */
public class XClientQueryHardwareMessage {

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        private XClientQueryHardwareMessage.Response.Result result = new XClientQueryHardwareMessage.Response.Result();

        @Data
        public static class Result {

            private TerminalDto terminal;
            private DeviceDto device;

        }
    }

    @Data
    public static class TerminalDto {

        /**
         * 终端唯一码
         */
        private String terminalUn;

        /**
         * 终端名称
         */
        private String terminalName;

        /**
         * 终端队列名称（有打印服务时有值）
         */
        private String terminalQueueName;

        /**
         * 状态(enable:启用 disable:未启用)
         */
        private String status;

        /**
         * 支持服务
         * print:打印 make:开票,originAccount:底账,assistant：辅助
         */
        private List<String> supportService;

        /**
         * 终端配置
         */
        private List<ConfigDto> configList;

    }

    @Data
    public static class DeviceDto {

        /**
         * 设备唯一码
         */
        private String deviceUn;

        /**
         * 设备类型
         * BW,BK,HX,HK,EK
         */
        private String deviceType;

        /**
         * 国税自定义密码
         */
        private String nationalTaxPassword;

        /**
         * 底账确认密码
         */
        private String elConfirmPassword;

        /**
         * 税务数字证书密码
         */
        private String taxDeviceDigitalPassword;

        /**
         * 税控盘密码
         */
        private String taxDevicePassword;

        /**
         * 开票队列名称
         */
        private String miQueueName;

        /**
         * 底账队列
         */
        private String elQueueName;

        /**
         * 状态(enable:启用 disable:未启用)
         */
        private String status;

        /**
         * 支持服务
         * print:打印 make:开票,originAccount:底账,assistant：辅助
         */
        private List<String> supportService;

        /**
         * 终端配置
         */
        private List<ConfigDto> configList;

    }

    @Data
    public static class ConfigDto {
        private String key;
        private String value;
    }
}
