package com.xforceplus.micro.tax.device.contract.model.hardware;

import com.xforceplus.micro.tax.device.contract.model.vatv2.model.BaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author Bobo
 * @create 2021/4/6 17:48
 * @since 1.0.0
 */
public class XClientUpgradeMessage {

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        private XClientUpgradeMessage.Response.Result result = new XClientUpgradeMessage.Response.Result();

        @Data
        public class Result {

            private List<UpgradeDto> upgradeList;

        }
    }

    @Data
    public static class UpgradeDto {

        /**
         * 产品
         */
        private String product;

        /**
         * 升级版本
         */
        private String upgradeVersion;

        /**
         * 升级方式
         */
        private String upgradeType;

        /**
         * 基线版本升级数量
         */
        private String baselineNum;

    }
}
