package com.xforceplus.micro.tax.device.contract.model.hardware.model;

import com.xforceplus.micro.tax.device.contract.model.vatv2.model.OrganizationDto;
import lombok.Data;

import java.util.List;

/**
 * 新增设备消息
 *
 * @author Bobo
 * @create 2021/7/22 10:13
 * @since 1.0.0
 */
@Data
public class TaxwareAddDeviceMessage {

    /**
     * 操作类型(create-创建，update-修改)
     */
    private String actionType;

    /**
     * 纳税人识别号
     */
    private String taxCode;

    /**
     * 设备唯一编号
     */
    private String deviceUn;

    /**
     * 税盘编号
     */
    private String deviceNo;

    /**
     * 税盘类型
     */
    private Integer taxDeviceType;

    /**
     * 设备类型，taxDevice：税盘，taxControlKey:税控钥匙，taxVUKey:VUKey，elTaxCert:税务证书
     */
    private String deviceType;

    /**
     * 设备状态(0：待审核 1:审核通过 2：审核失败 11：启用 12：未启用 21：关闭)
     */
    private Integer status;

    /**
     * 支持服务
     * make：开票 ，originAccount：底账，assistant：辅助
     */
    private List<String> supportService;

    /**
     * 终端Id
     */
    private Long terminalId;

    /**
     * 终端唯一码
     */
    private String terminalUn;

    /**
     * 组织信息
     */
    private OrganizationDto organization;

    /**
     * 国税自定义密码
     */
    private String nationalTaxPassword;

    /**
     * 抵账确认密码
     */
    private String elConfirmPassword;

    /**
     * 税控盘密码
     */
    private String taxDevicePassword;

    /**
     * 税务数字证书密码
     */
    private String taxDeviceDigitalPassword;
}
