package com.xforceplus.micro.tax.device.contract.model.hardware.model;

import lombok.Data;

import java.util.List;

/**
 * 新增终端消息
 *
 * @author Bobo
 * @create 2021/7/22 10:25
 * @since 1.0.0
 */
@Data
public class TaxwareAddTerminalMessage {

    /**
     * 纳税人识别号
     */
    private String taxCode;

    /**
     * 终端唯一码
     */
    private String terminalUn;

    /**
     * 终端类型 1：单盘 2：服务器 3:底账服务器 4:区块链终端 5:VUKey终端
     */
    private Integer terminalType;

    /**
     * 终端编号
     */
    private String terminalNo;

    /**
     * 终端名称
     */
    private String terminalName;

    /**
     * 设备状态(0：待审核 1:审核通过 2：审核失败 11：启用 12：未启用 21：关闭)
     */
    private Integer status;

    /**
     * 支持服务
     * make：开票 ，originAccount：底账，assistant：辅助
     */
    private List<String> supportService;
}
