package com.xforceplus.micro.tax.device.contract.model.inventory;

import lombok.Data;

import java.util.List;

/**
 * 发票库存上抛消息
 *
 * @author Bobo
 * @create 2021/8/18 17:08
 * @since 1.0.0
 */
@Data
public class InvoiceInventoryUploadAllMessage {

    /**
     * 税号
     */
    private String taxCode;

    /**
     * 设备编号
     */
    private String deviceNo;

    /**
     * 开票服务类型
     * invoice_helper：单盘
     * invoice_server ：税控服务器
     */
    private String invoiceServiceType;

    /**
     * 所属云
     * ac：阿里云
     * tc：腾讯云
     */
    private String cloud;

    /**
     * MI
     */
    private String mi;

    /**
     * 终端Un
     */
    private String terminalUn;

    /**
     * 终端编号
     */
    private String terminalNo;

    /**
     * 发票类型
     */
    private String invoiceType;

    /**
     * 下一张发票代码
     */
    private String nextInvoiceCode;

    /**
     * 下一张发票号码
     */
    private String nextInvoiceNo;

    /**
     * 库存数量
     */
    private Integer quantity;

    /**
     * 库存获取时间 格式：yyyy-MM-dd HH:mm:ss.SSS
     */
    private String inventoryTime;

    /**
     * 库存明细
     */
    private List<InvoiceInventoryDetail> invoiceInventoryDetail;

    @Data
    public static class InvoiceInventoryDetail {

        /**
         * 发票代码
         */
        private String invoiceCode;

        /**
         * 起始号码
         */
        private String startInvoiceNo;

        /**
         * 终止号码
         */
        private String endInvoiceNo;

        /**
         * 领购发票份数
         */
        private Integer purchaseQuantity;

        /**
         * 剩余发票份数
         */
        private Integer inventoryQuantity;

        /**
         * 领购日期
         */
        private String purchaseDate;

        /**
         * 领购人
         */
        private String purchasePerson;

    }

}
