package com.xforceplus.micro.tax.device.contract.model.inventory;

import lombok.Data;

import java.util.List;

/**
 * 服务器发票库存上抛消息
 *
 * @author Bobo
 * @create 2021/8/18 17:08
 * @since 1.0.0
 */
@Data
public class ServerInvoiceInventoryUploadMessage {

    /**
     * 所属云
     * ac：阿里云
     * tc：腾讯云
     */
    private String cloud;

    /**
     * 开票服务类型
     * invoice_helper：单盘
     * invoice_server ：税控服务器
     */
    private String invoiceServiceType = "invoice_server";

    /**
     * MI
     */
    private String mi;

    /**
     * 账号体系类型
     * 2.0 -- 2.0平台
     * 3.0 -- 3.0平台
     * 4.0 -- 4.0平台
     */
    private String accountType;

    /**
     * 事件类型
     * invoiced -- 开票后
     * timing   -- 定时任务
     */
    private String eventType;

    /**
     * 租户代码
     * 4.0平台：租户Id，其他平台：租户代码
     */
    private String tenantCode;

    /**
     * 税号
     */
    private String taxCode;

    /**
     * 公司名称
     */
    private String companyName;

    /**
     * 厂商标识
     * BW：百旺单盘
     * HX：航信单盘
     * EK：税务UKey
     * BK：百旺税控钥匙
     * HK：航信税控钥匙
     * BW-S：百旺核心板
     * HX-C：航信C48
     * PROVIDER-BW：供应商开票--百旺盘
     * PROVIDER-HX：供应商开票--航信盘
     * PROVIDER-EK：供应商开票--税务UKey盘
     */
    private String vendorType;

    /**
     * 发票类型
     */
    private String invoiceType;

    /**
     * 设备编号
     */
    private String deviceNo;

    /**
     * 终端编号
     */
    private String terminalNo;

    /**
     * 下一张发票代码
     */
    private String nextInvoiceCode;

    /**
     * 下一张发票号码
     */
    private String nextInvoiceNo;

    /**
     * 库存数量
     */
    private Integer quantity;

    /**
     * 库存获取时间 格式：yyyy-MM-dd HH:mm:ss.SSS
     */
    private String inventoryTime;

    /**
     * 库存明细
     */
    private List<InvoiceInventoryDetail> details;

    @Data
    public static class InvoiceInventoryDetail {

        /**
         * 发票代码
         */
        private String invoiceCode;

        /**
         * 起始号码
         */
        private String startInvoiceNo;

        /**
         * 终止号码
         */
        private String endInvoiceNo;

        /**
         * 领购发票份数
         */
        private Integer purchaseQuantity;

        /**
         * 剩余发票份数
         */
        private Integer inventoryQuantity;

        /**
         * 领购日期
         */
        private String purchaseDate;

        /**
         * 领购人
         */
        private String purchasePerson;

    }

}
