package com.xforceplus.micro.tax.device.contract.model.tenant;

import com.xforceplus.micro.tax.device.contract.model.client.devops.PageDTO;
import com.xforceplus.micro.tax.device.contract.model.vatv2.model.BaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.sql.Timestamp;
import java.util.List;

/**
 * @author Bobo
 * @create 2022/9/23 14:39
 * @since 1.0.0
 */
public class SupportServiceQueryMessage {
    @EqualsAndHashCode(callSuper = true)
    @Data
    public static class Response extends BaseResponseDto {

        /**
         * 查询数据结果
         */
        private Result result = new Result();

        @Data
        public static class Result {
            private PageDTO page;
            private List<ServiceInfoDTO> serviceList;
        }
    }

    @Data
    public static class ServiceInfoDTO {
        private Long id;
        private Timestamp createdAt;
        private Timestamp updatedAt;
        private Long tDeviceTenantTaxNoRelationId;
        private String tenantCode;
        private String tenantName;
        private String taxNo;
        private String companyName;
        private List<String> serviceTypeList;
        private String serviceName;
        private boolean serviceEnabledFlag;
        private Timestamp enabledTime;
        private Timestamp disabledTime;
        private String createdBy;
        private String updatedBy;
    }
}
