package com.xforceplus.micro.tax.device.contract.model.vatv2;

import com.xforceplus.micro.tax.device.contract.model.vatv2.model.BaseResponseDto;
import com.xforceplus.micro.tax.device.contract.model.vatv2.model.OrganizationDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

public class AddTerminalMessage {

    @Data
    public static class Request {

        /**
         * 纳税人识别号
         */
        private String taxCode;

        /**
         * 创建人
         */
        private String createdBy;

        /**
         * 设备类型(5:VUKey终端，默认值)
         */
        private Integer terminalType = 5;

        /**
         * 终端名称
         */
        private String terminalName;

        /**
         * 发票类型列表(至少有一个发票类型，虚拟ukey终端类型下，只能有1个发票类型)
         */
        private List<String> invoiceTypeList;

        /**
         * 组织信息
         */
        private OrganizationDto organization;

        /**
         * 设备(仅支持终端类型是虚拟UKey时，创建新的虚拟ukey设备或者绑定已有虚拟ukey设备)
         */
        private DeviceDto deviceInfo = new DeviceDto();

        @Data
        public static class DeviceDto {

            /**
             * 设备唯一码
             */
            private String deviceUn;

            /**
             * 操作类型(create-创建，bind-绑定,默认：create)
             */
            private String actionType = "create";

            /**
             * 设备异步审核结果回调队列（SQS队列）
             */
            private String callBackSqsQueue;
        }
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        private Result result;
    }

    @Data
    public static class Result {

        /**
         * 终端唯一码
         */
        private String terminalUn;

        /**
         * 设备唯一编号
         */
        private String deviceUn;

        /**
         * 终端状态(0：待审核  11：启用)
         */
        private Integer terminalStatus = 11;

        /**
         * 终端、设备状态(0：待审核  11：启用)
         */
        private Integer status = 11;
    }
}
