package com.xforceplus.micro.tax.device.contract.model.vehicle;

import com.xforceplus.micro.tax.device.contract.model.OpenApiBaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 机动车信息
 *
 * @author zhouwen
 * @date 2024-06-13 17:34
 */
public class VehicleMessage {

    @Data
    public static class Request {

        /**
         * 税号
         */
        private String taxNo;

        /**
         * 车辆识别代号/车架号码
         */
        private String vehicleNo;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends OpenApiBaseResponseDto {

        private Result result = new Result();

        @Data
        private static class Result {

            /**
             * 厂牌型号
             */
            private String vehicleBrand;

            /**
             * 合格证号
             */
            private String certificationNo;

            /**
             * 进口证明书号
             */
            private String importCertificationNo;

            /**
             * 发动机号码
             */
            private String engineNo;

            /**
             * 生产企业名称
             */
            private String manufacturerName;

            /**
             * 车辆识别代号/车架号码
             */
            private String vehicleNo;
        }
    }
}
