package com.xforceplus.micro.tax.device.contract.server;

import com.xforceplus.micro.tax.device.contract.model.CompanyRegisterRequest;
import com.xforceplus.micro.tax.device.contract.model.CompanyRegisterResponse;
import com.xforceplus.micro.tax.device.contract.model.CompanyRegisterResultRequest;
import com.xforceplus.micro.tax.device.contract.model.CompanyRegisterResultResponse;
import com.xforceplus.micro.tax.device.contract.model.CompanyStampRequest;
import com.xforceplus.micro.tax.device.contract.model.CompanyStampResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "company", description = "the company API")
public interface CompanyApi {

    @ApiOperation(value = "获取公司签章接口", notes = "", response = CompanyStampResponse.class, tags={ "Company", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "获取公司签章响应", response = CompanyStampResponse.class) })
    @RequestMapping(value = "/company/getCompanyStamp",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default CompanyStampResponse companyGetCompanyStampPost(@ApiParam(value = "获取公司签章请求"  )  @Valid @RequestBody CompanyStampRequest companyStampRequest) {
        Object[] params = new Object[] { companyStampRequest };
        //return FixtureService.getInstance().get(CompanyStampResponse.class, CompanyApi.class, "companyGetCompanyStampPost", params);
        return null;
    }

    @ApiOperation(value = "公司信息注册请求，证书生成接口", notes = "", response = CompanyRegisterResponse.class, tags={ "Company", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "公司信息注册请求响应", response = CompanyRegisterResponse.class) })
    @RequestMapping(value = "/company/register",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default CompanyRegisterResponse companyRegisterPost(@ApiParam(value = "公司信息注册请求"  )  @Valid @RequestBody CompanyRegisterRequest companyRegisterRequest) {
        Object[] params = new Object[] { companyRegisterRequest };
        //return FixtureService.getInstance().get(CompanyRegisterResponse.class, CompanyApi.class, "companyRegisterPost", params);
        return null;
    }

    @ApiOperation(value = "公司信息注册申请结果查询接口", notes = "", response = CompanyRegisterResultResponse.class, tags={ "Company", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "公司信息注册申请结果查询响应", response = CompanyRegisterResultResponse.class) })
    @RequestMapping(value = "/company/register/result",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default CompanyRegisterResultResponse companyRegisterResultPost(@ApiParam(value = "公司信息注册申请结果查询请求"  )  @Valid @RequestBody CompanyRegisterResultRequest companyRegisterResultRequest) {
        Object[] params = new Object[] { companyRegisterResultRequest };
        //return FixtureService.getInstance().get(CompanyRegisterResultResponse.class, CompanyApi.class, "companyRegisterResultPost", params);
        return null;
    }
}
