package com.xforceplus.micro.tax.device.contract.server;

import com.xforceplus.micro.tax.device.contract.model.AddMonitoredQueueRequest;
import com.xforceplus.micro.tax.device.contract.model.AddMonitoredQueueResponse;
import com.xforceplus.micro.tax.device.contract.model.QueryQueueStatusRequest;
import com.xforceplus.micro.tax.device.contract.model.QueryQueueStatusResponse;
import com.xforceplus.micro.tax.device.contract.model.RemoveMonitoredQueueRequest;
import com.xforceplus.micro.tax.device.contract.model.RemoveMonitoredQueueResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "monitor", description = "the monitor API")
public interface MonitorApi {

    @ApiOperation(value = "在线队列监听添加", notes = "", response = AddMonitoredQueueResponse.class, tags={ "monitor", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "在线队列监听删除添加", response = AddMonitoredQueueResponse.class) })
    @RequestMapping(value = "/monitor/queue/add",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default AddMonitoredQueueResponse monitorQueueAddPost(@ApiParam(value = "在线队列监听添加"  )  @Valid @RequestBody AddMonitoredQueueRequest addMonitoredQueueRequest) {
        Object[] params = new Object[] { addMonitoredQueueRequest };
        //return FixtureService.getInstance().get(AddMonitoredQueueResponse.class, MonitorApi.class, "monitorQueueAddPost", params);
        return null;
    }

    @ApiOperation(value = "在线队列监听删除", notes = "", response = RemoveMonitoredQueueResponse.class, tags={ "monitor", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "在线队列监听删除响应", response = RemoveMonitoredQueueResponse.class) })
    @RequestMapping(value = "/monitor/queue/remove",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default RemoveMonitoredQueueResponse monitorQueueRemovePost(@ApiParam(value = "在线队列监听删除"  )  @Valid @RequestBody RemoveMonitoredQueueRequest removeMonitoredQueueRequest) {
        Object[] params = new Object[] { removeMonitoredQueueRequest };
        //return FixtureService.getInstance().get(RemoveMonitoredQueueResponse.class, MonitorApi.class, "monitorQueueRemovePost", params);
        return null;
    }

    @ApiOperation(value = "队列在线情况查询", notes = "", response = QueryQueueStatusResponse.class, tags={ "monitor", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "队列在线情况查询响应", response = QueryQueueStatusResponse.class) })
    @RequestMapping(value = "/monitor/queue/status",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default QueryQueueStatusResponse monitorQueueStatusPost(@ApiParam(value = "队列在线情况查询"  )  @Valid @RequestBody QueryQueueStatusRequest queryQueueStatusRequest) {
        Object[] params = new Object[] { queryQueueStatusRequest };
        //return FixtureService.getInstance().get(QueryQueueStatusResponse.class, MonitorApi.class, "monitorQueueStatusPost", params);
        return null;
    }
}
