package com.xforceplus.micro.tax.device.contract.server;

import com.xforceplus.micro.tax.device.contract.model.AcquireTokenRequest1;
import com.xforceplus.micro.tax.device.contract.model.AcquireTokenResponse1;
import com.xforceplus.micro.tax.device.contract.model.AssignQueueRequest;
import com.xforceplus.micro.tax.device.contract.model.AssignQueueResponse;
import com.xforceplus.micro.tax.device.contract.model.QueryQueueStatusRequest1;
import com.xforceplus.micro.tax.device.contract.model.QueryQueueStatusResponse1;
import com.xforceplus.micro.tax.device.contract.model.QuerySqsStatusResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "mq", description = "the mq API")
public interface MqApi {

    @ApiOperation(value = "分配队列", notes = "", response = AssignQueueResponse.class, tags={ "MQ", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "分配队列响应", response = AssignQueueResponse.class) })
    @RequestMapping(value = "/mq/queue/assign",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default AssignQueueResponse mqQueueAssignPost(@ApiParam(value = "分配队列请求"  )  @Valid @RequestBody AssignQueueRequest assignQueueRequest) {
        Object[] params = new Object[] { assignQueueRequest };
        //return FixtureService.getInstance().get(AssignQueueResponse.class, MqApi.class, "mqQueueAssignPost", params);
        return null;
    }

    @ApiOperation(value = "查询队列状态", notes = "", response = QueryQueueStatusResponse1.class, tags={ "MQ", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "查询队列状态响应", response = QueryQueueStatusResponse1.class) })
    @RequestMapping(value = "/mq/queue/statusQuery",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default QueryQueueStatusResponse1 mqQueueStatusQueryPost(@ApiParam(value = "查询队列状态请求"  )  @Valid @RequestBody QueryQueueStatusRequest1 queryQueueStatusRequest) {
        Object[] params = new Object[] { queryQueueStatusRequest };
        //return FixtureService.getInstance().get(QueryQueueStatusResponse1.class, MqApi.class, "mqQueueStatusQueryPost", params);
        return null;
    }

    @ApiOperation(value = "获取token", notes = "", response = AcquireTokenResponse1.class, tags={ "MQ", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "获取token响应", response = AcquireTokenResponse1.class) })
    @RequestMapping(value = "/mq/sqs/acquireToken",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default AcquireTokenResponse1 mqSqsAcquireTokenPost(@ApiParam(value = "获取token请求"  )  @Valid @RequestBody AcquireTokenRequest1 acquireTokenRequest) {
        Object[] params = new Object[] { acquireTokenRequest };
        //return FixtureService.getInstance().get(AcquireTokenResponse1.class, MqApi.class, "mqSqsAcquireTokenPost", params);
        return null;
    }

    @ApiOperation(value = "批量查询SQS队列状态", notes = "", response = QuerySqsStatusResponse.class, tags={ "MQ", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "查询队列状态响应", response = QuerySqsStatusResponse.class) })
    @RequestMapping(value = "/mq/queue/sqs/status",
        produces = { "application/json" }, 
        consumes = { "*", "text/plain", "text/plain; charset=utf-8", "application/json" },
        method = RequestMethod.GET)
    default QuerySqsStatusResponse querySqsStatus(@ApiParam(value = "MI账号，一次查询最多支持400个") @Valid @RequestParam(value = "accounts", required = false) List<String> accounts) {
        Object[] params = new Object[] { accounts };
        //return FixtureService.getInstance().get(QuerySqsStatusResponse.class, MqApi.class, "querySqsStatus", params);
        return null;
    }
}
