package com.xforceplus.micro.tax.device.contract.server;

import com.xforceplus.micro.tax.device.contract.model.AcquireExtractRequest;
import com.xforceplus.micro.tax.device.contract.model.AcquireExtractResponse;
import com.xforceplus.micro.tax.device.contract.model.AcquireLicenseByKeyRequest;
import com.xforceplus.micro.tax.device.contract.model.AcquireLicenseRequest;
import com.xforceplus.micro.tax.device.contract.model.AcquireLicenseResponse;
import com.xforceplus.micro.tax.device.contract.model.AddDeviceRequest;
import com.xforceplus.micro.tax.device.contract.model.AddDeviceResponse;
import com.xforceplus.micro.tax.device.contract.model.AddTerminalRequest;
import com.xforceplus.micro.tax.device.contract.model.AddTerminalResponse;
import com.xforceplus.micro.tax.device.contract.model.ApplyLicenseRequest;
import com.xforceplus.micro.tax.device.contract.model.ApplyLicenseResponse;
import com.xforceplus.micro.tax.device.contract.model.BindLicenseRequest;
import com.xforceplus.micro.tax.device.contract.model.BindLicenseResponse;
import com.xforceplus.micro.tax.device.contract.model.BindTerminalRequest;
import com.xforceplus.micro.tax.device.contract.model.BindTerminalResponse;
import com.xforceplus.micro.tax.device.contract.model.CancelExtractRequest;
import com.xforceplus.micro.tax.device.contract.model.CancelExtractResponse;
import com.xforceplus.micro.tax.device.contract.model.DeviceCAQueryRequest;
import com.xforceplus.micro.tax.device.contract.model.DeviceCAQueryResponse;
import com.xforceplus.micro.tax.device.contract.model.DeviceOnlineInfoQueryRequest;
import com.xforceplus.micro.tax.device.contract.model.DeviceOnlineInfoQueryResponse;
import com.xforceplus.micro.tax.device.contract.model.LicenseKeyRequest;
import com.xforceplus.micro.tax.device.contract.model.LicenseKeyResponse;
import com.xforceplus.micro.tax.device.contract.model.QueryConfigRequest;
import com.xforceplus.micro.tax.device.contract.model.QueryConfigResponse;
import com.xforceplus.micro.tax.device.contract.model.QueryDeviceRequest;
import com.xforceplus.micro.tax.device.contract.model.QueryDeviceResponse;
import com.xforceplus.micro.tax.device.contract.model.QueryTerminalRequest;
import com.xforceplus.micro.tax.device.contract.model.QueryTerminalResponse;
import com.xforceplus.micro.tax.device.contract.model.RenewalLicenseRequest;
import com.xforceplus.micro.tax.device.contract.model.RenewalLicenseResponse;
import com.xforceplus.micro.tax.device.contract.model.SendLicenseRequest;
import com.xforceplus.micro.tax.device.contract.model.SendLicenseResponse;
import com.xforceplus.micro.tax.device.contract.model.SubscribeExtractRequest;
import com.xforceplus.micro.tax.device.contract.model.SubscribeExtractResponse;
import com.xforceplus.micro.tax.device.contract.model.TerminalBindClientRequest;
import com.xforceplus.micro.tax.device.contract.model.TerminalBindClientResponse;
import com.xforceplus.micro.tax.device.contract.model.UnBindTerminalRequest;
import com.xforceplus.micro.tax.device.contract.model.UnBindTerminalResponse;
import com.xforceplus.micro.tax.device.contract.model.UpdateDeviceRequest;
import com.xforceplus.micro.tax.device.contract.model.UpdateDeviceResponse;
import com.xforceplus.micro.tax.device.contract.model.UpdateDeviceStatusRequest;
import com.xforceplus.micro.tax.device.contract.model.UpdateDeviceStatusResponse;
import com.xforceplus.micro.tax.device.contract.model.UpdateTerminalRequest;
import com.xforceplus.micro.tax.device.contract.model.UpdateTerminalResponse;
import com.xforceplus.micro.tax.device.contract.model.UpdateTerminalStatusRequest;
import com.xforceplus.micro.tax.device.contract.model.UpdateTerminalStatusResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "device", description = "the device API")
public interface DeviceApi {

    @ApiOperation(value = "新增设备", notes = "", response = AddDeviceResponse.class, tags={ "Device", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "设备新增响应", response = AddDeviceResponse.class) })
    @RequestMapping(value = "/device/add",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default AddDeviceResponse deviceAddPost(@ApiParam(value = "新增设备，服务器模式的设备不需要传入：税务数字证书密码，盘密码，盘号。航信服务器模式只支持电票，百望服务器模式只支持：普票,电票，专票"  )  @Valid @RequestBody AddDeviceRequest addDeviceRequest) {
        Object[] params = new Object[] { addDeviceRequest };
        //return FixtureService.getInstance().get(AddDeviceResponse.class, DeviceApi.class, "deviceAddPost", params);
        return null;
    }

    @ApiOperation(value = "绑定终端", notes = "", response = BindTerminalResponse.class, tags={ "Device", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "响应", response = BindTerminalResponse.class) })
    @RequestMapping(value = "/device/bind",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default BindTerminalResponse deviceBindPost(@ApiParam(value = "税控钥匙绑定终端"  )  @Valid @RequestBody BindTerminalRequest bindTerminalRequest) {
        Object[] params = new Object[] { bindTerminalRequest };
        //return FixtureService.getInstance().get(BindTerminalResponse.class, DeviceApi.class, "deviceBindPost", params);
        return null;
    }

    @ApiOperation(value = "查询设备证书", notes = "", response = DeviceCAQueryResponse.class, tags={ "Device", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "查询设备证书,根据更新日期降序返回", response = DeviceCAQueryResponse.class) })
    @RequestMapping(value = "/device/ca/query",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default DeviceCAQueryResponse deviceCaQueryPost(@ApiParam(value = "查询设备证书,根据更新日期降序返回"  )  @Valid @RequestBody DeviceCAQueryRequest deviceCAQueryRequest) {
        Object[] params = new Object[] { deviceCAQueryRequest };
        //return FixtureService.getInstance().get(DeviceCAQueryResponse.class, DeviceApi.class, "deviceCaQueryPost", params);
        return null;
    }

    @ApiOperation(value = "获取税盘抽取订阅", notes = "", response = AcquireExtractResponse.class, tags={ "Device", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "获取税盘抽取订阅响应", response = AcquireExtractResponse.class) })
    @RequestMapping(value = "/device/extract/acquire",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default AcquireExtractResponse deviceExtractAcquirePost(@ApiParam(value = "获取税盘抽取订阅，抽取类型：1【抵账】2【税盘】3【销项】,抵账与销项传税号，税盘传设备唯一码或设备ID"  )  @Valid @RequestBody AcquireExtractRequest acquireExtractRequest) {
        Object[] params = new Object[] { acquireExtractRequest };
        //return FixtureService.getInstance().get(AcquireExtractResponse.class, DeviceApi.class, "deviceExtractAcquirePost", params);
        return null;
    }

    @ApiOperation(value = "取消税盘抽取订阅", notes = "", response = CancelExtractResponse.class, tags={ "Device", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "取消税盘抽取订阅响应", response = CancelExtractResponse.class) })
    @RequestMapping(value = "/device/extract/cancel",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default CancelExtractResponse deviceExtractCancelPost(@ApiParam(value = "取消税盘抽取订阅，抽取类型：1【抵账】2【税盘】3【销项】, 抵账与销项传税号，税盘传设备ID"  )  @Valid @RequestBody CancelExtractRequest cancelExtractRequest) {
        Object[] params = new Object[] { cancelExtractRequest };
        //return FixtureService.getInstance().get(CancelExtractResponse.class, DeviceApi.class, "deviceExtractCancelPost", params);
        return null;
    }

    @ApiOperation(value = "税盘抽取订阅", notes = "", response = SubscribeExtractResponse.class, tags={ "Device", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "税盘抽取订阅响应", response = SubscribeExtractResponse.class) })
    @RequestMapping(value = "/device/extract/subscribe",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default SubscribeExtractResponse deviceExtractSubscribePost(@ApiParam(value = "税盘抽取订阅"  )  @Valid @RequestBody SubscribeExtractRequest subscribeExtractRequest) {
        Object[] params = new Object[] { subscribeExtractRequest };
        //return FixtureService.getInstance().get(SubscribeExtractResponse.class, DeviceApi.class, "deviceExtractSubscribePost", params);
        return null;
    }

    @ApiOperation(value = "根据激活码获取授权文件", notes = "", response = AcquireLicenseResponse.class, tags={ "Device", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "授权文件获取响应", response = AcquireLicenseResponse.class) })
    @RequestMapping(value = "/device/license/acquireByKey",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default AcquireLicenseResponse deviceLicenseAcquireByKeyPost(@ApiParam(value = "根据激活码获取授权文件"  )  @Valid @RequestBody AcquireLicenseByKeyRequest acquireLicenseByKeyRequest) {
        Object[] params = new Object[] { acquireLicenseByKeyRequest };
        //return FixtureService.getInstance().get(AcquireLicenseResponse.class, DeviceApi.class, "deviceLicenseAcquireByKeyPost", params);
        return null;
    }

    @ApiOperation(value = "获取授权文件", notes = "", response = AcquireLicenseResponse.class, tags={ "Device", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "授权文件获取响应", response = AcquireLicenseResponse.class) })
    @RequestMapping(value = "/device/license/acquire",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default AcquireLicenseResponse deviceLicenseAcquirePost(@ApiParam(value = "授权文件获取"  )  @Valid @RequestBody AcquireLicenseRequest acquireLicenseRequest) {
        Object[] params = new Object[] { acquireLicenseRequest };
        //return FixtureService.getInstance().get(AcquireLicenseResponse.class, DeviceApi.class, "deviceLicenseAcquirePost", params);
        return null;
    }

    @ApiOperation(value = "生成授权文件", notes = "", response = ApplyLicenseResponse.class, tags={ "Device", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "授权文件申请响应", response = ApplyLicenseResponse.class) })
    @RequestMapping(value = "/device/license/apply",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default ApplyLicenseResponse deviceLicenseApplyPost(@ApiParam(value = "授权文件申请,如果此设备或终端已经有授权文件了，不会重新生成"  )  @Valid @RequestBody ApplyLicenseRequest applyLicenseRequest) {
        Object[] params = new Object[] { applyLicenseRequest };
        //return FixtureService.getInstance().get(ApplyLicenseResponse.class, DeviceApi.class, "deviceLicenseApplyPost", params);
        return null;
    }

    @ApiOperation(value = "绑定授权文件", notes = "", response = BindLicenseResponse.class, tags={ "Device", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "授权文件绑定响应", response = BindLicenseResponse.class) })
    @RequestMapping(value = "/device/license/bind",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default BindLicenseResponse deviceLicenseBindPost(@ApiParam(value = "授权文件绑定"  )  @Valid @RequestBody BindLicenseRequest bindLicenseRequest) {
        Object[] params = new Object[] { bindLicenseRequest };
        //return FixtureService.getInstance().get(BindLicenseResponse.class, DeviceApi.class, "deviceLicenseBindPost", params);
        return null;
    }

    @ApiOperation(value = "查询授权文件激活码", notes = "", response = LicenseKeyResponse.class, tags={ "Device", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "查询授权文件激活码", response = LicenseKeyResponse.class) })
    @RequestMapping(value = "/device/license/key/query",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default LicenseKeyResponse deviceLicenseKeyQueryPost(@ApiParam(value = "查询授权文件激活码"  )  @Valid @RequestBody LicenseKeyRequest licenseKeyRequest) {
        Object[] params = new Object[] { licenseKeyRequest };
        //return FixtureService.getInstance().get(LicenseKeyResponse.class, DeviceApi.class, "deviceLicenseKeyQueryPost", params);
        return null;
    }

    @ApiOperation(value = "续约授权文件", notes = "", response = RenewalLicenseResponse.class, tags={ "Device", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "续约授权文件响应", response = RenewalLicenseResponse.class) })
    @RequestMapping(value = "/device/license/renewal",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default RenewalLicenseResponse deviceLicenseRenewalPost(@ApiParam(value = "续约授权文件,为整个公司下的所有需要授权文件的设备，终端进行续约"  )  @Valid @RequestBody RenewalLicenseRequest renewalLicenseRequest) {
        Object[] params = new Object[] { renewalLicenseRequest };
        //return FixtureService.getInstance().get(RenewalLicenseResponse.class, DeviceApi.class, "deviceLicenseRenewalPost", params);
        return null;
    }

    @ApiOperation(value = "发送授权文件", notes = "", response = SendLicenseResponse.class, tags={ "Device", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "授权文件发送响应", response = SendLicenseResponse.class) })
    @RequestMapping(value = "/device/license/send",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default SendLicenseResponse deviceLicenseSendPost(@ApiParam(value = "授权文件发送，可以根据设备id或者终端id进行发送"  )  @Valid @RequestBody SendLicenseRequest sendLicenseRequest) {
        Object[] params = new Object[] { sendLicenseRequest };
        //return FixtureService.getInstance().get(SendLicenseResponse.class, DeviceApi.class, "deviceLicenseSendPost", params);
        return null;
    }

    @ApiOperation(value = "查询配置信息", notes = "", response = QueryConfigResponse.class, tags={ "Device", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "查询配置信息", response = QueryConfigResponse.class) })
    @RequestMapping(value = "/device/queryConfig",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default QueryConfigResponse deviceQueryConfigPost(@ApiParam(value = "查询配置信息"  )  @Valid @RequestBody QueryConfigRequest queryConfigRequest) {
        Object[] params = new Object[] { queryConfigRequest };
        //return FixtureService.getInstance().get(QueryConfigResponse.class, DeviceApi.class, "deviceQueryConfigPost", params);
        return null;
    }

    @ApiOperation(value = "查询设备是否在线", notes = "", response = DeviceOnlineInfoQueryResponse.class, tags={ "Device", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "设备在线信息获取", response = DeviceOnlineInfoQueryResponse.class) })
    @RequestMapping(value = "/device/queryOnlineFlag",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default DeviceOnlineInfoQueryResponse deviceQueryOnlineFlagPost(@ApiParam(value = "设备在线信息获取"  )  @Valid @RequestBody DeviceOnlineInfoQueryRequest deviceOnlineInfoQueryRequest) {
        Object[] params = new Object[] { deviceOnlineInfoQueryRequest };
        //return FixtureService.getInstance().get(DeviceOnlineInfoQueryResponse.class, DeviceApi.class, "deviceQueryOnlineFlagPost", params);
        return null;
    }

    @ApiOperation(value = "查询设备信息", notes = "", response = QueryDeviceResponse.class, tags={ "Device", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "设备信息获取", response = QueryDeviceResponse.class) })
    @RequestMapping(value = "/device/query",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default QueryDeviceResponse deviceQueryPost(@ApiParam(value = "设备信息获取"  )  @Valid @RequestBody QueryDeviceRequest queryDeviceRequest) {
        Object[] params = new Object[] { queryDeviceRequest };
        //return FixtureService.getInstance().get(QueryDeviceResponse.class, DeviceApi.class, "deviceQueryPost", params);
        return null;
    }

    @ApiOperation(value = "新增终端", notes = "", response = AddTerminalResponse.class, tags={ "Device", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "终端新增", response = AddTerminalResponse.class) })
    @RequestMapping(value = "/device/terminal/add",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default AddTerminalResponse deviceTerminalAddPost(@ApiParam(value = "终端新增"  )  @Valid @RequestBody AddTerminalRequest addTerminalRequest) {
        Object[] params = new Object[] { addTerminalRequest };
        //return FixtureService.getInstance().get(AddTerminalResponse.class, DeviceApi.class, "deviceTerminalAddPost", params);
        return null;
    }

    @ApiOperation(value = "查询终端绑定的客户端", notes = "", response = TerminalBindClientResponse.class, tags={ "Device", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "查询终端绑定的客户端CID", response = TerminalBindClientResponse.class) })
    @RequestMapping(value = "/device/terminal/bind/client/query",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default TerminalBindClientResponse deviceTerminalBindClientQueryPost(@ApiParam(value = "查询查询终端绑定的客户端CID"  )  @Valid @RequestBody TerminalBindClientRequest terminalBindClientRequest) {
        Object[] params = new Object[] { terminalBindClientRequest };
        //return FixtureService.getInstance().get(TerminalBindClientResponse.class, DeviceApi.class, "deviceTerminalBindClientQueryPost", params);
        return null;
    }

    @ApiOperation(value = "查询终端信息", notes = "", response = QueryTerminalResponse.class, tags={ "Device", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "终端信息获取响应", response = QueryTerminalResponse.class) })
    @RequestMapping(value = "/device/terminal/query",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default QueryTerminalResponse deviceTerminalQueryPost(@ApiParam(value = "终端信息获取"  )  @Valid @RequestBody QueryTerminalRequest queryTerminalRequest) {
        Object[] params = new Object[] { queryTerminalRequest };
        //return FixtureService.getInstance().get(QueryTerminalResponse.class, DeviceApi.class, "deviceTerminalQueryPost", params);
        return null;
    }

    @ApiOperation(value = "更新终端信息", notes = "", response = UpdateTerminalResponse.class, tags={ "Device", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "终端更新", response = UpdateTerminalResponse.class) })
    @RequestMapping(value = "/device/terminal/update",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default UpdateTerminalResponse deviceTerminalUpdatePost(@ApiParam(value = "终端更新"  )  @Valid @RequestBody UpdateTerminalRequest updateTerminalRequest) {
        Object[] params = new Object[] { updateTerminalRequest };
        //return FixtureService.getInstance().get(UpdateTerminalResponse.class, DeviceApi.class, "deviceTerminalUpdatePost", params);
        return null;
    }

    @ApiOperation(value = "更新终端状态", notes = "", response = UpdateTerminalStatusResponse.class, tags={ "Device", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "终端状态更新", response = UpdateTerminalStatusResponse.class) })
    @RequestMapping(value = "/device/terminal/updateStatus",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default UpdateTerminalStatusResponse deviceTerminalUpdateStatusPost(@ApiParam(value = "终端状态更新"  )  @Valid @RequestBody UpdateTerminalStatusRequest updateTerminalStatusRequest) {
        Object[] params = new Object[] { updateTerminalStatusRequest };
        //return FixtureService.getInstance().get(UpdateTerminalStatusResponse.class, DeviceApi.class, "deviceTerminalUpdateStatusPost", params);
        return null;
    }

    @ApiOperation(value = "解绑终端", notes = "", response = UnBindTerminalResponse.class, tags={ "Device", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "设备解绑响应", response = UnBindTerminalResponse.class) })
    @RequestMapping(value = "/device/unBind",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default UnBindTerminalResponse deviceUnBindPost(@ApiParam(value = "税控钥匙解绑终端"  )  @Valid @RequestBody UnBindTerminalRequest unBindTerminalRequest) {
        Object[] params = new Object[] { unBindTerminalRequest };
        //return FixtureService.getInstance().get(UnBindTerminalResponse.class, DeviceApi.class, "deviceUnBindPost", params);
        return null;
    }

    @ApiOperation(value = "更新设备信息", notes = "", response = UpdateDeviceResponse.class, tags={ "Device", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "设备状态更新响应", response = UpdateDeviceResponse.class) })
    @RequestMapping(value = "/device/update",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default UpdateDeviceResponse deviceUpdatePost(@ApiParam(value = "设备更新，仅更新传入的字段"  )  @Valid @RequestBody UpdateDeviceRequest updateDeviceRequest) {
        Object[] params = new Object[] { updateDeviceRequest };
        //return FixtureService.getInstance().get(UpdateDeviceResponse.class, DeviceApi.class, "deviceUpdatePost", params);
        return null;
    }

    @ApiOperation(value = "更新设备状态", notes = "", response = UpdateDeviceStatusResponse.class, tags={ "Device", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "设备状态更新", response = UpdateDeviceStatusResponse.class) })
    @RequestMapping(value = "/device/updateStatus",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default UpdateDeviceStatusResponse deviceUpdateStatusPost(@ApiParam(value = "设备状态更新"  )  @Valid @RequestBody UpdateDeviceStatusRequest updateDeviceStatusRequest) {
        Object[] params = new Object[] { updateDeviceStatusRequest };
        //return FixtureService.getInstance().get(UpdateDeviceStatusResponse.class, DeviceApi.class, "deviceUpdateStatusPost", params);
        return null;
    }
}
