package com.xforceplus.micro.tax.device.contract.server;

import com.xforceplus.micro.tax.device.contract.model.InvoiceDeposeRequest;
import com.xforceplus.micro.tax.device.contract.model.InvoiceDeposeResponse;
import com.xforceplus.micro.tax.device.contract.model.InvoiceDeposeResultRequest;
import com.xforceplus.micro.tax.device.contract.model.InvoiceDeposeResultResponse;
import com.xforceplus.micro.tax.device.contract.model.InvoiceDispatcherRequest;
import com.xforceplus.micro.tax.device.contract.model.InvoiceDispatcherResponse;
import com.xforceplus.micro.tax.device.contract.model.InvoiceDispatcherResultRequest;
import com.xforceplus.micro.tax.device.contract.model.InvoiceRecycleRequest;
import com.xforceplus.micro.tax.device.contract.model.InvoiceRecycleResultRequest;
import com.xforceplus.micro.tax.device.contract.model.InvoiceStockForThreePointFiveRequest;
import com.xforceplus.micro.tax.device.contract.model.InvoiceStockForThreePointFiveResponse;
import com.xforceplus.micro.tax.device.contract.model.InvoiceStockRequest;
import com.xforceplus.micro.tax.device.contract.model.InvoiceStockResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "invoiceStockManagement", description = "the invoiceStockManagement API")
public interface InvoiceStockManagementApi {

    @ApiOperation(value = "空白发票作废申请接口", notes = "", response = InvoiceDeposeResponse.class, tags={ "InvoiceStockManagement", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "空白发票作废申请响应", response = InvoiceDeposeResponse.class) })
    @RequestMapping(value = "/invoiceStockManagement/invoiceDepose/apply",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default InvoiceDeposeResponse invoiceStockManagementInvoiceDeposeApplyPost(@ApiParam(value = "空白发票作废申请请求"  )  @Valid @RequestBody InvoiceDeposeRequest invoiceDeposeRequest) {
        Object[] params = new Object[] { invoiceDeposeRequest };
        //return FixtureService.getInstance().get(InvoiceDeposeResponse.class, InvoiceStockManagementApi.class, "invoiceStockManagementInvoiceDeposeApplyPost", params);
        return null;
    }

    @ApiOperation(value = "空白发票作废结果接口", notes = "", response = InvoiceDeposeResultResponse.class, tags={ "InvoiceStockManagement", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "空白发票作废结果响应", response = InvoiceDeposeResultResponse.class) })
    @RequestMapping(value = "/invoiceStockManagement/invoiceDepose/result",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default InvoiceDeposeResultResponse invoiceStockManagementInvoiceDeposeResultPost(@ApiParam(value = "空白发票作废结果请求"  )  @Valid @RequestBody InvoiceDeposeResultRequest invoiceDeposeResultRequest) {
        Object[] params = new Object[] { invoiceDeposeResultRequest };
        //return FixtureService.getInstance().get(InvoiceDeposeResultResponse.class, InvoiceStockManagementApi.class, "invoiceStockManagementInvoiceDeposeResultPost", params);
        return null;
    }

    @ApiOperation(value = "发票分发申请接口", notes = "", response = InvoiceDispatcherResponse.class, tags={ "InvoiceStockManagement", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "发票分发申请响应", response = InvoiceDispatcherResponse.class) })
    @RequestMapping(value = "/invoiceStockManagement/invoiceDispatcher/apply",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default InvoiceDispatcherResponse invoiceStockManagementInvoiceDispatcherApplyPost(@ApiParam(value = "发票分发申请请求"  )  @Valid @RequestBody InvoiceDispatcherRequest invoiceDispatcherRequest) {
        Object[] params = new Object[] { invoiceDispatcherRequest };
        //return FixtureService.getInstance().get(InvoiceDispatcherResponse.class, InvoiceStockManagementApi.class, "invoiceStockManagementInvoiceDispatcherApplyPost", params);
        return null;
    }

    @ApiOperation(value = "发票分发结果接口", notes = "", response = InvoiceDispatcherResponse.class, tags={ "InvoiceStockManagement", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "发票分发结果响应", response = InvoiceDispatcherResponse.class) })
    @RequestMapping(value = "/invoiceStockManagement/invoiceDispatcher/result",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default InvoiceDispatcherResponse invoiceStockManagementInvoiceDispatcherResultPost(@ApiParam(value = "发票分发结果请求"  )  @Valid @RequestBody InvoiceDispatcherResultRequest invoiceDispatcherResultRequest) {
        Object[] params = new Object[] { invoiceDispatcherResultRequest };
        //return FixtureService.getInstance().get(InvoiceDispatcherResponse.class, InvoiceStockManagementApi.class, "invoiceStockManagementInvoiceDispatcherResultPost", params);
        return null;
    }

    @ApiOperation(value = "发票回收申请接口", notes = "", response = InvoiceDispatcherResponse.class, tags={ "InvoiceStockManagement", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "发票回收申请响应", response = InvoiceDispatcherResponse.class) })
    @RequestMapping(value = "/invoiceStockManagement/invoiceRecycle/apply",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default InvoiceDispatcherResponse invoiceStockManagementInvoiceRecycleApplyPost(@ApiParam(value = "发票回收申请请求"  )  @Valid @RequestBody InvoiceRecycleRequest invoiceRecycleRequest) {
        Object[] params = new Object[] { invoiceRecycleRequest };
        //return FixtureService.getInstance().get(InvoiceDispatcherResponse.class, InvoiceStockManagementApi.class, "invoiceStockManagementInvoiceRecycleApplyPost", params);
        return null;
    }

    @ApiOperation(value = "发票回收结果接口", notes = "", response = InvoiceDispatcherResponse.class, tags={ "InvoiceStockManagement", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "发票回收结果响应", response = InvoiceDispatcherResponse.class) })
    @RequestMapping(value = "/invoiceStockManagement/invoiceRecycle/result",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default InvoiceDispatcherResponse invoiceStockManagementInvoiceRecycleResultPost(@ApiParam(value = "发票回收结果请求"  )  @Valid @RequestBody InvoiceRecycleResultRequest invoiceRecycleResultRequest) {
        Object[] params = new Object[] { invoiceRecycleResultRequest };
        //return FixtureService.getInstance().get(InvoiceDispatcherResponse.class, InvoiceStockManagementApi.class, "invoiceStockManagementInvoiceRecycleResultPost", params);
        return null;
    }

    @ApiOperation(value = "3.5客户端发票库存信息查询接口", notes = "", response = InvoiceStockForThreePointFiveResponse.class, tags={ "InvoiceStockManagement", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "3.5库存查询响应", response = InvoiceStockForThreePointFiveResponse.class) })
    @RequestMapping(value = "/invoiceStockManagement/invoiceStockForClient",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default InvoiceStockForThreePointFiveResponse invoiceStockManagementInvoiceStockForClientPost(@ApiParam(value = "3.5客户端库存查询请求"  )  @Valid @RequestBody InvoiceStockForThreePointFiveRequest invoiceStockForThreePointFiveRequest) {
        Object[] params = new Object[] { invoiceStockForThreePointFiveRequest };
        //return FixtureService.getInstance().get(InvoiceStockForThreePointFiveResponse.class, InvoiceStockManagementApi.class, "invoiceStockManagementInvoiceStockForClientPost", params);
        return null;
    }

    @ApiOperation(value = "发票库存信息查询接口", notes = "", response = InvoiceStockResponse.class, tags={ "InvoiceStockManagement", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "库存查询响应", response = InvoiceStockResponse.class) })
    @RequestMapping(value = "/invoiceStockManagement/invoiceStock",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default InvoiceStockResponse invoiceStockManagementInvoiceStockPost(@ApiParam(value = "库存查询请求"  )  @Valid @RequestBody InvoiceStockRequest invoiceStockRequest) {
        Object[] params = new Object[] { invoiceStockRequest };
        //return FixtureService.getInstance().get(InvoiceStockResponse.class, InvoiceStockManagementApi.class, "invoiceStockManagementInvoiceStockPost", params);
        return null;
    }
}
